/// <reference path="./internal_*.d.ts" />
declare namespace dev.lambdaurora.spruceui.util {
    interface Nameable {
        abstract getName(): string;
        get name(): string
        (): string;
    }
    type Nameable_ = Nameable;
}
declare namespace dev.ftb.mods.ftblibrary.ui {
    class Widget implements Internal.IScreenWrapper, Internal.Comparable<dev.ftb.mods.ftblibrary.ui.Widget> {
        constructor(p: Internal.Panel_)
        shouldDraw(): boolean;
        static getClipboardString(): string;
        mousePressed(button: Internal.MouseButton_): boolean;
        compareTo(widget: dev.ftb.mods.ftblibrary.ui.Widget_): number;
        getY(): number;
        closeGui(openPrevScreen: boolean): void;
        compareTo(arg0: any): number;
        mouseDragged(button: number, dragX: number, dragY: number): boolean;
        getPosX(): number;
        closeGui(): void;
        setPos(x: number, y: number): void;
        openGui(): void;
        keyPressed(key: dev.ftb.mods.ftblibrary.ui.input.Key_): boolean;
        getWidgetType(): Internal.WidgetType;
        isGhostIngredientTarget(ingredient: any): boolean;
        setX(v: number): void;
        getPartialTicks(): number;
        getWidth(): number;
        getDrawLayer(): Internal.Widget$DrawLayer;
        getGui(): Internal.BaseScreen;
        tick(): void;
        keyReleased(key: dev.ftb.mods.ftblibrary.ui.input.Key_): void;
        getMouseX(): number;
        static isShiftKeyDown(): boolean;
        getTitle(): net.minecraft.network.chat.Component;
        openAfter(runnable: Internal.Runnable_): Internal.Runnable;
        static setClipboardString(string: string): void;
        draw(graphics: Internal.GuiGraphics_, theme: Internal.Theme_, x: number, y: number, w: number, h: number): void;
        handleClick(scheme: string, path: string): boolean;
        getX(): number;
        getParent(): Internal.Panel;
        closeContextMenu(): void;
        mouseScrolled(scroll: number): boolean;
        run(): void;
        getIngredientUnderMouse(): Internal.Optional<Internal.PositionedIngredient>;
        shouldAddMouseOverText(): boolean;
        isEnabled(): boolean;
        getPosY(): number;
        updateMouseOver(mouseX: number, mouseY: number): void;
        static isMouseButtonDown(button: Internal.MouseButton_): boolean;
        setY(v: number): void;
        static isKeyDown(key: number): boolean;
        static isCtrlKeyDown(): boolean;
        setPosAndSize(x: number, y: number, w: number, h: number): this;
        setWidth(v: number): void;
        getHeight(): number;
        isMouseOver(): boolean;
        playClickSound(): void;
        setSize(w: number, h: number): void;
        charTyped(c: string, modifiers: Internal.KeyModifiers_): boolean;
        mouseDoubleClicked(button: Internal.MouseButton_): boolean;
        getCursor(): Internal.CursorType;
        onClosed(): void;
        acceptGhostIngredient(ingredient: any): void;
        getMouseY(): number;
        mouseReleased(button: Internal.MouseButton_): void;
        collidesWith(x: number, y: number, w: number, h: number): boolean;
        openGuiLater(): void;
        checkMouseOver(mouseX: number, mouseY: number): boolean;
        getScreen(): com.mojang.blaze3d.platform.Window;
        setDrawLayer(drawLayer: Internal.Widget$DrawLayer_): void;
        handleClick(click: string): boolean;
        setHeight(v: number): void;
        addMouseOverText(list: Internal.TooltipList_): void;
        get clipboardString(): string
        get y(): number
        get posX(): number
        get widgetType(): Internal.WidgetType
        set x(v: number)
        get partialTicks(): number
        get width(): number
        get drawLayer(): Internal.Widget$DrawLayer
        get gui(): Internal.BaseScreen
        get mouseX(): number
        get shiftKeyDown(): boolean
        get title(): net.minecraft.network.chat.Component
        set clipboardString(string: string)
        get x(): number
        get parent(): Internal.Panel
        get ingredientUnderMouse(): Internal.Optional<Internal.PositionedIngredient>
        get enabled(): boolean
        get posY(): number
        set y(v: number)
        get ctrlKeyDown(): boolean
        set width(v: number)
        get height(): number
        get mouseOver(): boolean
        get cursor(): Internal.CursorType
        get mouseY(): number
        get screen(): com.mojang.blaze3d.platform.Window
        set drawLayer(drawLayer: Internal.Widget$DrawLayer_)
        set height(v: number)
        width: number;
        height: number;
        posY: number;
        posX: number;
    }
    type Widget_ = Widget;
}
declare namespace Internal {
    class MutableArmorTier implements Internal.ArmorMaterial {
        constructor(id: string, p: Internal.ArmorMaterial_)
        getDefenseForType(equipmentSlot: Internal.ArmorItem$Type_): number;
        getDurabilityForType(equipmentSlot: Internal.ArmorItem$Type_): number;
        getVanillaRepairIngredient(): Internal.Ingredient;
        getKnockbackResistance(): number;
        getEnchantmentValue(): number;
        setToughness(f: number): void;
        setEnchantmentValue(i: number): void;
        setSlotProtections(p: number[]): void;
        setEquipSound(e: Internal.SoundEvent_): void;
        setKnockbackResistance(f: number): void;
        setName(name: string): void;
        getName(): string;
        getToughness(): number;
        setDurabilityMultiplier(m: number): void;
        setRepairIngredient(in_: Internal.Ingredient_): void;
        getEquipSound(): Internal.SoundEvent;
        get vanillaRepairIngredient(): Internal.Ingredient
        get knockbackResistance(): number
        get enchantmentValue(): number
        set toughness(f: number)
        set enchantmentValue(i: number)
        set slotProtections(p: number[])
        set equipSound(e: Internal.SoundEvent_)
        set knockbackResistance(f: number)
        set name(name: string)
        get name(): string
        get toughness(): number
        set durabilityMultiplier(m: number)
        set repairIngredient(in_: Internal.Ingredient_)
        get equipSound(): Internal.SoundEvent
        readonly parent: Internal.ArmorMaterial;
    }
    type MutableArmorTier_ = MutableArmorTier;
    class BoilerData {
        constructor()
        isPassive(boilerSize: number): boolean;
        write(): Internal.CompoundTag;
        checkPipeOrganAdvancement(controller: Internal.FluidTankBlockEntity_): void;
        queueSoundOnSide(pos: BlockPos_, side: Internal.Direction_): void;
        calcMinMaxForSize(boilerSize: number): void;
        isPassive(): boolean;
        updateTemperature(controller: Internal.FluidTankBlockEntity_): boolean;
        getSizeComponent(forGoggles: boolean, useBlocksAsBars: boolean, ...styles: Internal.ChatFormatting_[]): Internal.MutableComponent;
        getMaxHeatLevelForBoilerSize(boilerSize: number): number;
        isActive(): boolean;
        getEngineEfficiency(boilerSize: number): number;
        evaluate(controller: Internal.FluidTankBlockEntity_): boolean;
        getHeatComponent(forGoggles: boolean, useBlocksAsBars: boolean, ...styles: Internal.ChatFormatting_[]): Internal.MutableComponent;
        read(nbt: Internal.CompoundTag_, boilerSize: number): void;
        tick(controller: Internal.FluidTankBlockEntity_): void;
        getWaterComponent(forGoggles: boolean, useBlocksAsBars: boolean, ...styles: Internal.ChatFormatting_[]): Internal.MutableComponent;
        updateOcclusion(controller: Internal.FluidTankBlockEntity_): void;
        createHandler(): Internal.BoilerData$BoilerFluidHandler;
        clear(): void;
        getMaxHeatLevelForWaterSupply(): number;
        getTheoreticalHeatLevel(): number;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, boilerSize: number): boolean;
        getHeatLevelTextComponent(): Internal.MutableComponent;
        get passive(): boolean
        get active(): boolean
        get maxHeatLevelForWaterSupply(): number
        get theoreticalHeatLevel(): number
        get heatLevelTextComponent(): Internal.MutableComponent
        passiveHeat: boolean;
        waterSupply: number;
        attachedWhistles: number;
        activeHeat: number;
        attachedEngines: number;
        gauge: Internal.LerpedFloat;
        needsHeatLevelUpdate: boolean;
        occludedDirections: boolean[];
    }
    type BoilerData_ = BoilerData;
    interface SimpleTextureAccessor {
        abstract getLocation(): ResourceLocation;
        get location(): ResourceLocation
        (): ResourceLocation_;
    }
    type SimpleTextureAccessor_ = SimpleTextureAccessor;
    class BambooLeaves extends Internal.Enum<Internal.BambooLeaves> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf($$0: string): Internal.BambooLeaves;
        getSerializedName(): string;
        static values(): Internal.BambooLeaves[];
        get serializedName(): string
        static readonly SMALL: Internal.BambooLeaves;
        static readonly NONE: Internal.BambooLeaves;
        static readonly LARGE: Internal.BambooLeaves;
    }
    type BambooLeaves_ = "large" | "small" | "none" | BambooLeaves;
    class NullIota$1 extends Internal.IotaType<Internal.NullIota> {
        deserialize(tag: Internal.Tag_, world: Internal.ServerLevel_): Internal.NullIota;
    }
    type NullIota$1_ = NullIota$1;
    class NixieTubeDisplaySource extends Internal.SingleLineDisplaySource {
        constructor()
    }
    type NixieTubeDisplaySource_ = NixieTubeDisplaySource;
    interface AnimationController$CustomKeyframeHandler <A extends Internal.GeoAnimatable> {
        abstract handle(arg0: Internal.CustomInstructionKeyframeEvent_<A>): void;
        (arg0: Internal.CustomInstructionKeyframeEvent<A>): void;
    }
    type AnimationController$CustomKeyframeHandler_<A extends Internal.GeoAnimatable> = AnimationController$CustomKeyframeHandler<A>;
    interface BootstapContext <T> {
        register($$0: Internal.ResourceKey_<T>, $$1: T): Internal.Holder$Reference<T>;
        abstract register(arg0: Internal.ResourceKey_<T>, arg1: T, arg2: Internal.Lifecycle_): Internal.Holder$Reference<T>;
        abstract lookup<S>(arg0: Internal.ResourceKey_<Internal.Registry<S>>): Internal.HolderGetter<S>;
    }
    type BootstapContext_<T> = BootstapContext<T>;
    class CameraType extends Internal.Enum<Internal.CameraType> {
        isMirrored(): boolean;
        static values(): Internal.CameraType[];
        isFirstPerson(): boolean;
        static valueOf($$0: string): Internal.CameraType;
        cycle(): this;
        get mirrored(): boolean
        get firstPerson(): boolean
        static readonly THIRD_PERSON_BACK: Internal.CameraType;
        static readonly THIRD_PERSON_FRONT: Internal.CameraType;
        static readonly FIRST_PERSON: Internal.CameraType;
    }
    type CameraType_ = "first_person" | "third_person_back" | "third_person_front" | CameraType;
    interface MinecraftExtension {
        abstract port_lib$getGameConfig(): Internal.GameConfig;
        (): Internal.GameConfig_;
    }
    type MinecraftExtension_ = MinecraftExtension;
    class InItemGroupAttribute$Type implements Internal.ItemAttributeType {
        constructor()
        getAllAttributes(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemAttribute>;
        createAttribute(): Internal.ItemAttribute;
    }
    type InItemGroupAttribute$Type_ = InItemGroupAttribute$Type;
    class ClientboundSetBorderSizePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.WorldBorder_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getSize(): number;
        isSkippable(): boolean;
        get size(): number
        get skippable(): boolean
    }
    type ClientboundSetBorderSizePacket_ = ClientboundSetBorderSizePacket;
    abstract class ItemRelay extends Internal.BlockItem implements Internal.GeoItem {
        constructor(properties: Internal.Item$Properties_)
        stopTriggeredArmorAnim(relatedEntity: Internal.Entity_, instanceId: number, controllerName: string, animName: string): void;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        getTick(itemStack: any): number;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        syncAnimData<D>(instanceId: number, dataTicket: Internal.SerializableDataTicket_<D>, data: D, entityToTrack: Internal.Entity_): void;
        setAttackSpeed(attackSpeed: number): void;
        isPerspectiveAware(): boolean;
        triggerAnim<D>(relatedEntity: Internal.Entity_, instanceId: number, controllerName: string, animName: string): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        abstract getRenderProvider(): Internal.Supplier<any>;
        getCreativeTab(): string;
        animatableCacheOverride(): Internal.AnimatableInstanceCache;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        setAnimData<D>(relatedEntity: Internal.Entity_, instanceId: number, dataTicket: Internal.SerializableDataTicket_<D>, data: D): void;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        triggerAnim(instanceId: number, controllerName: string, animName: string, packetCallback: Internal.GeckoLibNetwork$IPacketCallback_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        static registerSyncedAnimatable(animatable: Internal.GeoAnimatable_): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getBoneResetTime(): number;
        triggerArmorAnim(relatedEntity: Internal.Entity_, instanceId: number, controllerName: string, animName: string): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getAnimatableInstanceCache(): Internal.AnimatableInstanceCache;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getAnimData<D>(instanceId: number, dataTicket: Internal.SerializableDataTicket_<D>): D;
        shouldPlayAnimsWhileGamePaused(): boolean;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static getId(stack: Internal.ItemStack_): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        abstract createRenderer(arg0: Internal.Consumer_<any>): void;
        static getOrAssignId(stack: Internal.ItemStack_, level: Internal.ServerLevel_): number;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        registerControllers(data: Internal.AnimatableManager$ControllerRegistrar_): void;
        static makeRenderer(item: Internal.GeoItem_): Internal.Supplier<any>;
        stopTriggeredAnim(relatedEntity: Internal.Entity_, instanceId: number, controllerName: string, animName: string): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get perspectiveAware(): boolean
        get renderProvider(): Internal.Supplier<any>
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        get boneResetTime(): number
        get animatableInstanceCache(): Internal.AnimatableInstanceCache
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type ItemRelay_ = ItemRelay;
    class PixelBuffer {
        constructor(w: number, h: number)
        setPixels(p: number[]): void;
        setRGB(x: number, y: number, col: number): void;
        copy(): this;
        getWidth(): number;
        getRGB(startX: number, startY: number, w: number, h: number, p: number[]): number[];
        static from(stream: Internal.InputStream_): Internal.PixelBuffer;
        setRGB(startX: number, startY: number, w: number, h: number, rgbArray: number[]): void;
        toImage(type: number): Internal.BufferedImage;
        static from(img: Internal.BufferedImage_): Internal.PixelBuffer;
        getRGB(x: number, y: number): number;
        fill(col: number): void;
        toByteBuffer(alpha: boolean): Internal.ByteBuffer;
        getPixels(): number[];
        getSubimage(x: number, y: number, w: number, h: number): this;
        setRGB(startX: number, startY: number, buffer: Internal.PixelBuffer_): void;
        getHeight(): number;
        fill(startX: number, startY: number, w: number, h: number, col: number): void;
        set pixels(p: number[])
        get width(): number
        get pixels(): number[]
        get height(): number
    }
    type PixelBuffer_ = PixelBuffer;
    class Raster {
        createCompatibleWritableRaster(arg0: number, arg1: number, arg2: number, arg3: number): Internal.WritableRaster;
        getBounds(): Internal.Rectangle;
        createCompatibleWritableRaster(arg0: Internal.Rectangle_): Internal.WritableRaster;
        getSampleModelTranslateY(): number;
        getSample(arg0: number, arg1: number, arg2: number): number;
        static createWritableRaster(arg0: Internal.SampleModel_, arg1: Internal.DataBuffer_, arg2: Internal.Point_): Internal.WritableRaster;
        static createInterleavedRaster(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Point_): Internal.WritableRaster;
        getPixels(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): number[];
        getPixel(arg0: number, arg1: number, arg2: number[]): number[];
        static createBandedRaster(arg0: Internal.DataBuffer_, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: number[], arg6: Internal.Point_): Internal.WritableRaster;
        getDataElements(arg0: number, arg1: number, arg2: any): any;
        getDataBuffer(): Internal.DataBuffer;
        static createWritableRaster(arg0: Internal.SampleModel_, arg1: Internal.Point_): Internal.WritableRaster;
        getPixels(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): number[];
        createCompatibleWritableRaster(arg0: number, arg1: number): Internal.WritableRaster;
        static createPackedRaster(arg0: Internal.DataBuffer_, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Internal.Point_): Internal.WritableRaster;
        static createRaster(arg0: Internal.SampleModel_, arg1: Internal.DataBuffer_, arg2: Internal.Point_): Internal.Raster;
        static createBandedRaster(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: number[], arg6: Internal.Point_): Internal.WritableRaster;
        getSampleDouble(arg0: number, arg1: number, arg2: number): number;
        getDataElements(arg0: number, arg1: number, arg2: number, arg3: number, arg4: any): any;
        getNumDataElements(): number;
        getMinX(): number;
        getHeight(): number;
        getTransferType(): number;
        getMinY(): number;
        getSamples(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number[]): number[];
        static createPackedRaster(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Internal.Point_): Internal.WritableRaster;
        createTranslatedChild(arg0: number, arg1: number): this;
        static createPackedRaster(arg0: Internal.DataBuffer_, arg1: number, arg2: number, arg3: number, arg4: Internal.Point_): Internal.WritableRaster;
        getSamples(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number[]): number[];
        getWidth(): number;
        static createInterleavedRaster(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number[], arg6: Internal.Point_): Internal.WritableRaster;
        getSampleModel(): Internal.SampleModel;
        getNumBands(): number;
        getSamples(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number[]): number[];
        createCompatibleWritableRaster(): Internal.WritableRaster;
        getSampleFloat(arg0: number, arg1: number, arg2: number): number;
        getParent(): this;
        createChild(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number[]): this;
        static createBandedRaster(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Point_): Internal.WritableRaster;
        getPixel(arg0: number, arg1: number, arg2: number[]): number[];
        static createInterleavedRaster(arg0: Internal.DataBuffer_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number[], arg6: Internal.Point_): Internal.WritableRaster;
        getPixel(arg0: number, arg1: number, arg2: number[]): number[];
        static createPackedRaster(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Internal.Point_): Internal.WritableRaster;
        getSampleModelTranslateX(): number;
        getPixels(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): number[];
        get bounds(): Internal.Rectangle
        get sampleModelTranslateY(): number
        get dataBuffer(): Internal.DataBuffer
        get numDataElements(): number
        get minX(): number
        get height(): number
        get transferType(): number
        get minY(): number
        get width(): number
        get sampleModel(): Internal.SampleModel
        get numBands(): number
        get parent(): Internal.Raster
        get sampleModelTranslateX(): number
    }
    type Raster_ = Raster;
    interface Short2LongFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.IntToLongFunction {
        composeReference<T>(arg0: Internal.Reference2ShortFunction_<T>): Internal.Reference2LongFunction<T>;
        andThenChar(arg0: Internal.Long2CharFunction_): Internal.Short2CharFunction;
        andThenReference<T>(arg0: Internal.Long2ReferenceFunction_<T>): Internal.Short2ReferenceFunction<T>;
        composeFloat(arg0: Internal.Float2ShortFunction_): Internal.Float2LongFunction;
        apply(arg0: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        remove(arg0: number): number;
        composeInt(arg0: Internal.Int2ShortFunction_): Internal.Int2LongFunction;
        composeChar(arg0: Internal.Char2ShortFunction_): Internal.Char2LongFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeObject<T>(arg0: Internal.Object2ShortFunction_<T>): Internal.Object2LongFunction<T>;
        andThenDouble(arg0: Internal.Long2DoubleFunction_): Internal.Short2DoubleFunction;
        andThenFloat(arg0: Internal.Long2FloatFunction_): Internal.Short2FloatFunction;
        put(arg0: number, arg1: number): number;
        composeLong(arg0: Internal.Long2ShortFunction_): Internal.Long2LongFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenShort(arg0: Internal.Long2ShortFunction_): Internal.Short2ShortFunction;
        andThenInt(arg0: Internal.Long2IntFunction_): Internal.Short2IntFunction;
        defaultReturnValue(): number;
        andThenLong(arg0: Internal.Long2LongFunction_): this;
        containsKey(arg0: number): boolean;
        andThenByte(arg0: Internal.Long2ByteFunction_): Internal.Short2ByteFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        abstract get(arg0: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        getOrDefault(arg0: number, arg1: number): number;
        size(): number;
        composeDouble(arg0: Internal.Double2ShortFunction_): Internal.Double2LongFunction;
        composeShort(arg0: Internal.Short2ShortFunction_): this;
        /**
         * @deprecated
        */
        applyAsLong(arg0: number): number;
        clear(): void;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        composeByte(arg0: Internal.Byte2ShortFunction_): Internal.Byte2LongFunction;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: number): void;
        andThenObject<T>(arg0: Internal.Long2ObjectFunction_<T>): Internal.Short2ObjectFunction<T>;
        (arg0: number): number;
    }
    type Short2LongFunction_ = Short2LongFunction;
    class StandardBogeyBlockEntity extends Internal.AbstractBogeyBlockEntity implements Internal.IStandardBogeyTEVirtualCoupling {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getFront(): boolean;
        setFront(front: boolean): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setCouplingDistance(distance: number): void;
        onLoad(): void;
        setCouplingDirection(direction: Internal.Direction_): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getCouplingDirection(): Internal.Direction;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getCouplingDistance(): number;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get front(): boolean
        set front(front: boolean)
        set couplingDistance(distance: number)
        set couplingDirection(direction: Internal.Direction_)
        get couplingDirection(): Internal.Direction
        get couplingDistance(): number
        get infiniteBoundingBox(): Internal.AABB
    }
    type StandardBogeyBlockEntity_ = StandardBogeyBlockEntity;
    class TimeOfDayDisplaySource extends Internal.SingleLineDisplaySource {
        constructor()
        static readonly EMPTY_TIME: Internal.MutableComponent;
    }
    type TimeOfDayDisplaySource_ = TimeOfDayDisplaySource;
    abstract class VertexSorters$AbstractVertexSorter implements Internal.VertexSorting {
        sort(positions: Vec3f_[]): number[];
        static byDistance(x: number, y: number, z: number): Internal.VertexSorting;
        static byDistance($$0: Internal.VertexSorting$DistanceFunction_): Internal.VertexSorting;
        static byDistance($$0: Vec3f_): Internal.VertexSorting;
    }
    type VertexSorters$AbstractVertexSorter_ = VertexSorters$AbstractVertexSorter;
    class TextureAtlasSprite implements Internal.ITextureAtlasSpriteExtension {
        constructor($$0: ResourceLocation_, $$1: Internal.SpriteContents_, $$2: number, $$3: number, $$4: number, $$5: number)
        wrap($$0: Internal.VertexConsumer_): Internal.VertexConsumer;
        getX(): number;
        getY(): number;
        getPixelRGBA(frameIndex: number, x: number, y: number): number;
        contents(): Internal.SpriteContents;
        getUOffset($$0: number): number;
        uploadFirstFrame(): void;
        uvShrinkRatio(): number;
        atlasLocation(): ResourceLocation;
        getU($$0: number): number;
        createTicker(): Internal.TextureAtlasSprite$Ticker;
        getVOffset($$0: number): number;
        getV1(): number;
        getV($$0: number): number;
        getU1(): number;
        handler$epb000$modelfix$cancelShrink(cir: Internal.CallbackInfoReturnable_<any>): void;
        getU0(): number;
        getV0(): number;
        get x(): number
        get y(): number
        get v1(): number
        get u1(): number
        get u0(): number
        get v0(): number
    }
    type TextureAtlasSprite_ = TextureAtlasSprite;
    class VinesFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type VinesFeature_ = VinesFeature;
    interface ICustomCableConnection {
        abstract getCableConnectionLength(arg0: Internal.AECableType_): number;
        (arg0: Internal.AECableType): number;
    }
    type ICustomCableConnection_ = ICustomCableConnection;
    abstract class BaseInternalInventory implements Internal.InternalInventory {
        constructor()
        simulateRemove(amount: number, filter: Internal.ItemStack_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        addItems(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        toContainer(): net.minecraft.world.Container;
        getSubInventory(fromSlotInclusive: number, toSlotExclusive: number): Internal.InternalInventory;
        isEmpty(): boolean;
        removeItems(amount: number, filter: Internal.ItemStack_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        sendChangeNotification(slot: number): void;
        toStorage(): Internal.Storage<Internal.ItemVariant>;
        abstract getStackInSlot(arg0: number): Internal.ItemStack;
        removeSimilarItems(amount: number, filter: Internal.ItemStack_, fuzzyMode: Internal.FuzzyMode_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        static wrapExternal(be: Internal.BlockEntity_, side: Internal.Direction_): Internal.ItemTransfer;
        static empty(): Internal.InternalInventory;
        getSlotInv(slotIndex: number): Internal.InternalInventory;
        mayAllowInsertion(): boolean;
        addItems(stack: Internal.ItemStack_): Internal.ItemStack;
        getSlotLimit(slot: number): number;
        iterator(): Internal.Iterator<Internal.ItemStack>;
        simulateSimilarRemove(amount: number, filter: Internal.ItemStack_, fuzzyMode: Internal.FuzzyMode_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        spliterator(): Internal.Spliterator<Internal.ItemStack>;
        simulateAdd(stack: Internal.ItemStack_): Internal.ItemStack;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        abstract size(): number;
        forEach(arg0: Internal.Consumer_<Internal.ItemStack>): void;
        abstract setItemDirect(arg0: number, arg1: Internal.ItemStack_): void;
        clear(): void;
        getRedstoneSignal(): number;
        static wrapExternal(level: Internal.Level_, pos: BlockPos_, side: Internal.Direction_): Internal.ItemTransfer;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        get empty(): boolean
        get redstoneSignal(): number
    }
    type BaseInternalInventory_ = BaseInternalInventory;
    class PickupUpgradeWrapper extends Internal.UpgradeWrapperBase<Internal.PickupUpgradeWrapper, Internal.PickupUpgradeItem> implements Internal.IPickupResponseUpgrade, Internal.IContentsFilteredUpgrade {
        constructor(storageWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        canBeDisabled(): boolean;
        hideSettingsTab(): boolean;
        pickup(world: Internal.Level_, stack: Internal.ItemStack_, ctx: Internal.TransactionContext_): Internal.ItemStack;
        getFilterLogic(): Internal.FilterLogic;
        onAdded(): void;
        onBeforeRemoved(): void;
        get filterLogic(): Internal.FilterLogic
    }
    type PickupUpgradeWrapper_ = PickupUpgradeWrapper;
    class StackedContents {
        constructor()
        accountStack($$0: Internal.ItemStack_): void;
        canCraft($$0: Internal.Recipe_<any>, $$1: Internal.IntList_): boolean;
        canCraft($$0: Internal.Recipe_<any>, $$1: Internal.IntList_, $$2: number): boolean;
        accountStack($$0: Internal.ItemStack_, $$1: number): void;
        clear(): void;
        accountSimpleStack($$0: Internal.ItemStack_): void;
        static fromStackingIndex($$0: number): Internal.ItemStack;
        static getStackingIndex($$0: Internal.ItemStack_): number;
        getBiggestCraftableStack($$0: Internal.Recipe_<any>, $$1: Internal.IntList_): number;
        getBiggestCraftableStack($$0: Internal.Recipe_<any>, $$1: number, $$2: Internal.IntList_): number;
        readonly contents: Internal.Int2IntMap;
    }
    type StackedContents_ = StackedContents;
    interface StructureAccess {
        abstract addReferenceForStructure(arg0: Internal.Structure_, arg1: number): void;
        abstract getAllReferences(): Internal.Map<Internal.Structure, Internal.LongSet>;
        abstract setAllReferences(arg0: Internal.Map_<Internal.Structure, Internal.LongSet>): void;
        abstract getStartForStructure(arg0: Internal.Structure_): Internal.StructureStart;
        abstract setStartForStructure(arg0: Internal.Structure_, arg1: Internal.StructureStart_): void;
        abstract getReferencesForStructure(arg0: Internal.Structure_): Internal.LongSet;
        get allReferences(): Internal.Map<Internal.Structure, Internal.LongSet>
        set allReferences(arg0: Internal.Map_<Internal.Structure, Internal.LongSet>)
    }
    type StructureAccess_ = StructureAccess;
    class DiskItem extends Internal.Item implements Internal.IColouredItem {
        constructor(settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static createFromIDAndColour(id: number, label: string, colour: number): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static getDiskID(stack: Internal.ItemStack_): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        withColour(stack: Internal.ItemStack_, colour: number): Internal.ItemStack;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static getColourBasic(stack: Internal.ItemStack_): number;
        static setColourBasic(stack: Internal.ItemStack_, colour: number): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        static setDiskID(stack: Internal.ItemStack_, id: number): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getColour(stack: Internal.ItemStack_): number;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type DiskItem_ = DiskItem;
    class DripstoneSplatterFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static isAir(level: Internal.LevelSimulatedReader_, pos: BlockPos_): boolean;
    }
    type DripstoneSplatterFeature_ = DripstoneSplatterFeature;
    class AbstractDirectionalFunnelBlock extends Internal.AbstractFunnelBlock {
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.FunnelBlockEntity>): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.FunnelBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        handleBox(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, chance: number, state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): void;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.FunnelBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        emi(): Internal.EmiStack;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.FunnelBlockEntity>;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.DirectionProperty;
    }
    type AbstractDirectionalFunnelBlock_ = AbstractDirectionalFunnelBlock;
    class ComponentOrientation implements Internal.Serializable {
        /**
         * @deprecated
        */
        static getOrientation(arg0: Internal.ResourceBundle_): Internal.ComponentOrientation;
        isLeftToRight(): boolean;
        static getOrientation(arg0: Internal.Locale_): Internal.ComponentOrientation;
        isHorizontal(): boolean;
        get leftToRight(): boolean
        get horizontal(): boolean
        static readonly RIGHT_TO_LEFT: Internal.ComponentOrientation;
        static readonly UNKNOWN: Internal.ComponentOrientation;
        static readonly LEFT_TO_RIGHT: Internal.ComponentOrientation;
    }
    type ComponentOrientation_ = ComponentOrientation;
    class ChainConveyorPackage {
        constructor(chainPosition: number, item: Internal.ItemStack_, netId: number)
        constructor(chainPosition: number, item: Internal.ItemStack_)
        physicsData(level: Internal.LevelAccessor_): Internal.ChainConveyorPackage$ChainConveyorPackagePhysicsData;
        write(): Internal.CompoundTag;
        writeToClient(): Internal.CompoundTag;
        static read(compoundTag: Internal.CompoundTag_): Internal.ChainConveyorPackage;
        item: Internal.ItemStack;
        yaw: number;
        worldPosition: Vec3d;
        chainPosition: number;
        netId: number;
        justFlipped: boolean;
        static readonly netIdGenerator: 0;
        static readonly physicsDataCache: Internal.WorldAttached<Internal.Cache<number, Internal.ChainConveyorPackage$ChainConveyorPackagePhysicsData>>;
    }
    type ChainConveyorPackage_ = ChainConveyorPackage;
    class VecDeltaCodec {
        constructor()
        encodeY($$0: Vec3d_): number;
        decode($$0: number, $$1: number, $$2: number): Vec3d;
        encodeX($$0: Vec3d_): number;
        encodeZ($$0: Vec3d_): number;
        delta($$0: Vec3d_): Vec3d;
        setBase($$0: Vec3d_): void;
        set base($$0: Vec3d_)
    }
    type VecDeltaCodec_ = VecDeltaCodec;
    class CherryFoliagePlacer extends Internal.FoliagePlacer {
        constructor($$0: Internal.IntProvider_, $$1: Internal.IntProvider_, $$2: Internal.IntProvider_, $$3: number, $$4: number, $$5: number, $$6: number)
        static readonly CODEC: Internal.Codec<Internal.CherryFoliagePlacer>;
    }
    type CherryFoliagePlacer_ = CherryFoliagePlacer;
    class Widget$DrawLayer extends Internal.Enum<Internal.Widget$DrawLayer> {
        static values(): Internal.Widget$DrawLayer[];
        static valueOf(name: string): Internal.Widget$DrawLayer;
        static readonly BACKGROUND: Internal.Widget$DrawLayer;
        static readonly FOREGROUND: Internal.Widget$DrawLayer;
    }
    type Widget$DrawLayer_ = "foreground" | "background" | Widget$DrawLayer;
    class ServerboundSignUpdatePacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: BlockPos_, $$1: boolean, $$2: string, $$3: string, $$4: string, $$5: string)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getPos(): BlockPos;
        write($$0: Internal.FriendlyByteBuf_): void;
        isFrontText(): boolean;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getLines(): string[];
        isSkippable(): boolean;
        get pos(): BlockPos
        get frontText(): boolean
        get lines(): string[]
        get skippable(): boolean
    }
    type ServerboundSignUpdatePacket_ = ServerboundSignUpdatePacket;
    class TieredChannelValues {
        constructor(starter: number, basic: number, hardened: number, blazing: number, niotic: number, spirited: number, nitro: number)
        static getDefault(): Internal.TieredChannelValues;
        get(tier: owmii.powah.block.Tier_): number;
        get "default"(): Internal.TieredChannelValues
        hardened: number;
        blazing: number;
        basic: number;
        spirited: number;
        niotic: number;
        nitro: number;
        starter: number;
    }
    type TieredChannelValues_ = TieredChannelValues;
    interface FluidStateExtension {
        getFluidType(): Internal.FluidType;
        get fluidType(): Internal.FluidType
    }
    type FluidStateExtension_ = FluidStateExtension;
    class AmbientParticleSettings {
        constructor($$0: Internal.ParticleOptions_, $$1: number)
        getOptions(): Internal.ParticleOptions;
        canSpawn($$0: Internal.RandomSource_): boolean;
        get options(): Internal.ParticleOptions
        static readonly CODEC: Internal.Codec<Internal.AmbientParticleSettings>;
    }
    type AmbientParticleSettings_ = AmbientParticleSettings;
    class KnifeItem extends Internal.DiggerItem implements io.github.fabricators_of_create.porting_lib.tool.extensions.ItemStackExtensions, Internal.CustomEnchantingBehaviorItem {
        constructor(tier: Internal.Tier_, attackDamage: number, attackSpeed: number, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        canApplyAtEnchantingTable(stack: Internal.ItemStack_, enchantment: Internal.Enchantment_): boolean;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        canPerformAction(toolAction: Internal.ToolAction_): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        static init(): void;
        isBookEnchantable(stack: Internal.ItemStack_, book: Internal.ItemStack_): boolean;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly KNIFE_ACTIONS: Internal.Set<Internal.ToolAction>;
    }
    type KnifeItem_ = KnifeItem;
    interface VisualizationLevel extends Internal.LevelAccessor {
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_): Internal.Player;
        dayTime(): number;
        abstract getShade(arg0: Internal.Direction_, arg1: boolean): number;
        getSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        isUnobstructed($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        getMaxSection(): number;
        abstract getLevelData(): Internal.LevelData;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getSectionYFromSectionIndex($$0: number): number;
        abstract players(): Internal.List<Internal.Player>;
        abstract getBiomeManager(): Internal.BiomeManager;
        abstract getRandom(): Internal.RandomSource;
        isEmptyBlock($$0: BlockPos_): boolean;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        abstract removeBlock(arg0: BlockPos_, arg1: boolean): boolean;
        playSound($$0: Internal.Player_, $$1: BlockPos_, $$2: Internal.SoundEvent_, $$3: Internal.SoundSource_): void;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        getTimeOfDay($$0: number): number;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getHeightmapPos($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        blockUpdated($$0: BlockPos_, $$1: Internal.Block_): void;
        abstract setBlock(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: number, arg3: number): boolean;
        abstract isClientSide(): boolean;
        getEntities($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.Entity>;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_): Internal.List<T>;
        abstract getBlockTicks(): Internal.LevelTickAccess<Internal.Block>;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getPathfindingCostFromLightLevels($$0: BlockPos_): number;
        abstract dimensionType(): Internal.DimensionType;
        abstract getSkyDarken(): number;
        getMinBuildHeight(): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number): void;
        getLoadedChunk(chunkX: number, chunkZ: number): Internal.ChunkAccess;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<any>;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean): Internal.Player;
        abstract destroyBlock(arg0: BlockPos_, arg1: boolean, arg2: Internal.Entity_, arg3: number): boolean;
        /**
         * @deprecated
        */
        hasChunkAt($$0: number, $$1: number): boolean;
        /**
         * @deprecated
        */
        abstract getSeaLevel(): number;
        abstract getFluidTicks(): Internal.LevelTickAccess<Internal.Fluid>;
        getSectionIndex($$0: number): number;
        getDirectSignalTo($$0: BlockPos_): number;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: number, $$2: number, $$3: number): Internal.Player;
        getMaxBuildHeight(): number;
        /**
         * @deprecated
        */
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number): void;
        getChunk($$0: number, $$1: number): Internal.ChunkAccess;
        addFreshEntity($$0: Internal.Entity_): boolean;
        hasSignal($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        getHeight(): number;
        getChunk($$0: BlockPos_): Internal.ChunkAccess;
        abstract isFluidAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.FluidState>): boolean;
        abstract getWorldBorder(): Internal.WorldBorder;
        getMaxLocalRawBrightness($$0: BlockPos_): number;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        /**
         * @deprecated
        */
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        /**
         * @deprecated
        */
        hasChunkAt($$0: BlockPos_): boolean;
        getBiome($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue($$0: BlockPos_): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: Internal.TickPriority_): void;
        hasNearbyAlivePlayer($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        abstract gameEvent(arg0: Internal.GameEvent_, arg1: Vec3d_, arg2: Internal.GameEvent$Context_): void;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number): Internal.Player;
        neighborShapeChanged($$0: Internal.Direction_, $$1: Internal.BlockState_, $$2: BlockPos_, $$3: BlockPos_, $$4: number, $$5: number): void;
        getControlInputSignal($$0: BlockPos_, $$1: Internal.Direction_, $$2: boolean): number;
        getBlockTint($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        getMinSection(): number;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3d_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3d>;
        abstract getBlockState(arg0: BlockPos_): Internal.BlockState;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        abstract playSound(arg0: Internal.Player_, arg1: BlockPos_, arg2: Internal.SoundEvent_, arg3: Internal.SoundSource_, arg4: number, arg5: number): void;
        getNearestPlayer($$0: Internal.Entity_, $$1: number): Internal.Player;
        hasNeighborSignal($$0: BlockPos_): boolean;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        abstract addParticle(arg0: Internal.ParticleOptions_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): void;
        abstract getCurrentDifficultyAt(arg0: BlockPos_): Internal.DifficultyInstance;
        getDifficulty(): Internal.Difficulty;
        canSeeSky($$0: BlockPos_): boolean;
        abstract enabledFeatures(): Internal.FeatureFlagSet;
        getMoonPhase(): number;
        isUnobstructed($$0: Internal.Entity_): boolean;
        getNearestEntity<T extends Internal.LivingEntity>($$0: Internal.List_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number): T;
        abstract getUncachedNoiseBiome(arg0: number, arg1: number, arg2: number): Internal.Holder<Internal.Biome>;
        abstract getEntities(arg0: Internal.Entity_, arg1: Internal.AABB_, arg2: Internal.Predicate_<Internal.Entity>): Internal.List<Internal.Entity>;
        getPlayerByUUID($$0: Internal.UUID_): Internal.Player;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        holderLookup<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup<T>;
        abstract getHeight(arg0: Internal.Heightmap$Types_, arg1: number, arg2: number): number;
        getSectionsCount(): number;
        abstract isStateAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.BlockState>): boolean;
        getNearbyPlayers($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: Internal.AABB_): Internal.List<Internal.Player>;
        getSectionIndexFromSectionY($$0: number): number;
        abstract getServer(): Internal.MinecraftServer;
        abstract levelEvent(arg0: Internal.Player_, arg1: number, arg2: BlockPos_, arg3: number): void;
        setBlock($$0: BlockPos_, $$1: Internal.BlockState_, $$2: number): boolean;
        getChunk($$0: number, $$1: number, $$2: Internal.ChunkStatus_): Internal.ChunkAccess;
        noCollision($$0: Internal.Entity_): boolean;
        abstract getEntities<T extends Internal.Entity>(arg0: Internal.EntityTypeTest_<Internal.Entity, T>, arg1: Internal.AABB_, arg2: Internal.Predicate_<T>): Internal.List<T>;
        getBestNeighborSignal($$0: BlockPos_): number;
        hasChunk($$0: number, $$1: number): boolean;
        getNearbyEntities<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: Internal.AABB_): Internal.List<T>;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getMoonBrightness(): number;
        noCollision($$0: Internal.AABB_): boolean;
        isWaterAt($$0: BlockPos_): boolean;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        getEntityCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        abstract getLightEngine(): Internal.LevelLightEngine;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        abstract getBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        getNoiseBiome($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        gameEvent($$0: Internal.GameEvent_, $$1: BlockPos_, $$2: Internal.GameEvent$Context_): void;
        noCollision($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number, $$3: Internal.TickPriority_): void;
        isOutsideBuildHeight($$0: number): boolean;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Entity>): Internal.Player;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: Vec3d_): void;
        abstract getFluidState(arg0: BlockPos_): Internal.FluidState;
        abstract getChunkSource(): Internal.ChunkSource;
        abstract getChunk(arg0: number, arg1: number, arg2: Internal.ChunkStatus_, arg3: boolean): Internal.ChunkAccess;
        abstract registryAccess(): Internal.RegistryAccess;
        findSupportingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Optional<BlockPos>;
        levelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        abstract nextSubTickCount(): number;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: BlockPos_): void;
        getChunkForCollisions($$0: number, $$1: number): Internal.BlockGetter;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getNearestEntity<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number, $$6: Internal.AABB_): T;
        isAreaLoaded(center: BlockPos_, range: number): boolean;
        supportsVisualization(): boolean;
        traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get maxSection(): number
        get levelData(): Internal.LevelData
        get biomeManager(): Internal.BiomeManager
        get random(): Internal.RandomSource
        get clientSide(): boolean
        get blockTicks(): Internal.LevelTickAccess<Internal.Block>
        get skyDarken(): number
        get minBuildHeight(): number
        /**
         * @deprecated
        */
        get seaLevel(): number
        get fluidTicks(): Internal.LevelTickAccess<Internal.Fluid>
        get maxBuildHeight(): number
        get height(): number
        get worldBorder(): Internal.WorldBorder
        get minSection(): number
        get difficulty(): Internal.Difficulty
        get moonPhase(): number
        get sectionsCount(): number
        get server(): Internal.MinecraftServer
        get moonBrightness(): number
        get lightEngine(): Internal.LevelLightEngine
        get chunkSource(): Internal.ChunkSource
        get maxLightLevel(): number
    }
    type VisualizationLevel_ = VisualizationLevel;
    class ToolAction {
        name(): string;
        static getActions(): Internal.Collection<Internal.ToolAction>;
        static get(name: string): Internal.ToolAction;
        get actions(): Internal.Collection<Internal.ToolAction>
    }
    type ToolAction_ = ToolAction;
    class SignalBlockEntity extends Internal.SmartBlockEntity implements Internal.TransformableBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        enterState(state: Internal.SignalBlockEntity$SignalState_): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getState(): Internal.SignalBlockEntity$SignalState;
        setOverlay(state: Internal.SignalBlockEntity$OverlayState_): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getOverlay(): Internal.SignalBlockEntity$OverlayState;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        isPowered(): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getSignal(): Internal.SignalBoundary;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        transform(be: Internal.BlockEntity_, transform: Internal.StructureTransform_): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getReportedPower(): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get state(): Internal.SignalBlockEntity$SignalState
        set overlay(state: Internal.SignalBlockEntity$OverlayState_)
        get overlay(): Internal.SignalBlockEntity$OverlayState
        get powered(): boolean
        get signal(): Internal.SignalBoundary
        get infiniteBoundingBox(): Internal.AABB
        get reportedPower(): boolean
        edgePoint: Internal.TrackTargetingBehaviour<Internal.SignalBoundary>;
        computerBehaviour: Internal.AbstractComputerBehaviour;
    }
    type SignalBlockEntity_ = SignalBlockEntity;
    interface StorableItemStack {
        abstract registerToInventory(arg0: Internal.LithiumStackList_, arg1: number): void;
        abstract unregisterFromInventory(arg0: Internal.LithiumStackList_): void;
        abstract unregisterFromInventory(arg0: Internal.LithiumStackList_, arg1: number): void;
    }
    type StorableItemStack_ = StorableItemStack;
    class ChestMenuInventoryClickEvent {
        constructor(slot: Internal.Slot_, type: Internal.ClickType_, button: number)
        setItem(item: Internal.ItemStack_): void;
        getItem(): Internal.ItemStack;
        getIndex(): number;
        set item(item: Internal.ItemStack_)
        get item(): Internal.ItemStack
        get index(): number
        readonly button: number;
        readonly type: Internal.ClickType;
    }
    type ChestMenuInventoryClickEvent_ = ChestMenuInventoryClickEvent;
    interface Teleportable {
        abstract iceandfire$setCustomTeleportTarget(arg0: Internal.PortalInfo_): void;
        (arg0: Internal.PortalInfo): void;
    }
    type Teleportable_ = Teleportable;
    class ThreadLocal <T> {
        constructor()
        remove(): void;
        static withInitial<S>(arg0: Internal.Supplier_<S>): Internal.ThreadLocal<S>;
        get(): T;
        set(arg0: T): void;
    }
    type ThreadLocal_<T> = ThreadLocal<T>;
    interface Double2FloatFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.DoubleUnaryOperator {
        compose(arg0: Internal.DoubleUnaryOperator_): Internal.DoubleUnaryOperator;
        composeShort(arg0: Internal.Short2DoubleFunction_): Internal.Short2FloatFunction;
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        andThenShort(arg0: Internal.Float2ShortFunction_): Internal.Double2ShortFunction;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        composeLong(arg0: Internal.Long2DoubleFunction_): Internal.Long2FloatFunction;
        defaultReturnValue(arg0: number): void;
        composeChar(arg0: Internal.Char2DoubleFunction_): Internal.Char2FloatFunction;
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenLong(arg0: Internal.Float2LongFunction_): Internal.Double2LongFunction;
        composeReference<T>(arg0: Internal.Reference2DoubleFunction_<T>): Internal.Reference2FloatFunction<T>;
        andThenDouble(arg0: Internal.Float2DoubleFunction_): Internal.Double2DoubleFunction;
        andThenFloat(arg0: Internal.Float2FloatFunction_): this;
        composeDouble(arg0: Internal.Double2DoubleFunction_): this;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        apply(arg0: number): number;
        composeInt(arg0: Internal.Int2DoubleFunction_): Internal.Int2FloatFunction;
        andThenChar(arg0: Internal.Float2CharFunction_): Internal.Double2CharFunction;
        abstract get(arg0: number): number;
        composeObject<T>(arg0: Internal.Object2DoubleFunction_<T>): Internal.Object2FloatFunction<T>;
        composeFloat(arg0: Internal.Float2DoubleFunction_): Internal.Float2FloatFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        defaultReturnValue(): number;
        applyAsDouble(arg0: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenInt(arg0: Internal.Float2IntFunction_): Internal.Double2IntFunction;
        containsKey(arg0: number): boolean;
        andThenObject<T>(arg0: Internal.Float2ObjectFunction_<T>): Internal.Double2ObjectFunction<T>;
        size(): number;
        andThenByte(arg0: Internal.Float2ByteFunction_): Internal.Double2ByteFunction;
        andThen(arg0: Internal.DoubleUnaryOperator_): Internal.DoubleUnaryOperator;
        composeByte(arg0: Internal.Byte2DoubleFunction_): Internal.Byte2FloatFunction;
        identity(): Internal.DoubleUnaryOperator;
        andThenReference<T>(arg0: Internal.Float2ReferenceFunction_<T>): Internal.Double2ReferenceFunction<T>;
        clear(): void;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        getOrDefault(arg0: number, arg1: number): number;
        (arg0: number): number;
    }
    type Double2FloatFunction_ = Double2FloatFunction;
    class HexDir$Companion {
        constructor($constructor_marker: any_)
        fromString(key: string): Internal.HexDir;
        getCODEC(): Internal.Codec<Internal.HexDir>;
        get CODEC(): Internal.Codec<Internal.HexDir>
    }
    type HexDir$Companion_ = HexDir$Companion;
    abstract class Image {
        flush(): void;
        getAccelerationPriority(): number;
        abstract getHeight(arg0: Internal.ImageObserver_): number;
        getCapabilities(arg0: Internal.GraphicsConfiguration_): Internal.ImageCapabilities;
        abstract getWidth(arg0: Internal.ImageObserver_): number;
        abstract getProperty(arg0: string, arg1: Internal.ImageObserver_): any;
        abstract getGraphics(): Internal.Graphics;
        getScaledInstance(arg0: number, arg1: number, arg2: number): this;
        setAccelerationPriority(arg0: number): void;
        abstract getSource(): Internal.ImageProducer;
        get accelerationPriority(): number
        get graphics(): Internal.Graphics
        set accelerationPriority(arg0: number)
        get source(): Internal.ImageProducer
        static readonly UndefinedProperty: any;
        static readonly SCALE_DEFAULT: 1;
        static readonly SCALE_FAST: 2;
        static readonly SCALE_REPLICATE: 8;
        static readonly SCALE_AREA_AVERAGING: 16;
        static readonly SCALE_SMOOTH: 4;
    }
    type Image_ = Image;
    class DragSource implements Internal.Serializable {
        constructor()
        startDrag(arg0: Internal.DragGestureEvent_, arg1: Internal.Cursor_, arg2: Internal.Image_, arg3: Internal.Point_, arg4: Internal.Transferable_, arg5: Internal.DragSourceListener_): void;
        removeDragSourceListener(arg0: Internal.DragSourceListener_): void;
        createDefaultDragGestureRecognizer(arg0: Internal.Component_, arg1: number, arg2: Internal.DragGestureListener_): Internal.DragGestureRecognizer;
        getListeners<T extends Internal.EventListener>(arg0: T): T[];
        getDragSourceListeners(): Internal.DragSourceListener[];
        static isDragImageSupported(): boolean;
        static getDragThreshold(): number;
        startDrag(arg0: Internal.DragGestureEvent_, arg1: Internal.Cursor_, arg2: Internal.Transferable_, arg3: Internal.DragSourceListener_): void;
        static getDefaultDragSource(): Internal.DragSource;
        startDrag(arg0: Internal.DragGestureEvent_, arg1: Internal.Cursor_, arg2: Internal.Transferable_, arg3: Internal.DragSourceListener_, arg4: Internal.FlavorMap_): void;
        getDragSourceMotionListeners(): Internal.DragSourceMotionListener[];
        startDrag(arg0: Internal.DragGestureEvent_, arg1: Internal.Cursor_, arg2: Internal.Image_, arg3: Internal.Point_, arg4: Internal.Transferable_, arg5: Internal.DragSourceListener_, arg6: Internal.FlavorMap_): void;
        addDragSourceListener(arg0: Internal.DragSourceListener_): void;
        createDragGestureRecognizer<T extends Internal.DragGestureRecognizer>(arg0: T, arg1: Internal.Component_, arg2: number, arg3: Internal.DragGestureListener_): T;
        removeDragSourceMotionListener(arg0: Internal.DragSourceMotionListener_): void;
        getFlavorMap(): Internal.FlavorMap;
        addDragSourceMotionListener(arg0: Internal.DragSourceMotionListener_): void;
        get dragSourceListeners(): Internal.DragSourceListener[]
        get dragImageSupported(): boolean
        get dragThreshold(): number
        get defaultDragSource(): Internal.DragSource
        get dragSourceMotionListeners(): Internal.DragSourceMotionListener[]
        get flavorMap(): Internal.FlavorMap
        static readonly DefaultMoveDrop: Internal.Cursor;
        static readonly DefaultMoveNoDrop: Internal.Cursor;
        static readonly DefaultLinkDrop: Internal.Cursor;
        static readonly DefaultCopyNoDrop: Internal.Cursor;
        static readonly DefaultLinkNoDrop: Internal.Cursor;
        static readonly DefaultCopyDrop: Internal.Cursor;
    }
    type DragSource_ = DragSource;
    class SlimesteelBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type SlimesteelBlock_ = SlimesteelBlock;
    class Hotbar extends Internal.ForwardingList<Internal.ItemStack> {
        constructor()
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        removeLast(): Internal.ItemStack;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        stream(): Internal.Stream<Internal.ItemStack>;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        static of<E>(...arg0: E[]): Internal.List<E>;
        getLast(): Internal.ItemStack;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        replaceAll(arg0: Internal.UnaryOperator_<Internal.ItemStack>): void;
        reversed(): Internal.SequencedCollection<any>;
        addFirst(arg0: Internal.ItemStack_): void;
        fromTag($$0: Internal.ListTag_): void;
        addLast(arg0: Internal.ItemStack_): void;
        parallelStream(): Internal.Stream<Internal.ItemStack>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        createTag(): Internal.ListTag;
        abstract toArray<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        removeFirst(): Internal.ItemStack;
        abstract iterator(): Internal.Iterator<Internal.ItemStack>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        sort(arg0: Internal.Comparator_<Internal.ItemStack>): void;
        spliterator(): Internal.Spliterator<Internal.ItemStack>;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        forEach(arg0: Internal.Consumer_<Internal.ItemStack>): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        getFirst(): Internal.ItemStack;
        removeIf(arg0: Internal.Predicate_<Internal.ItemStack>): boolean;
        get last(): Internal.ItemStack
        get first(): Internal.ItemStack
    }
    type Hotbar_ = Hotbar;
    interface SeekableByteChannel extends Internal.ByteChannel {
        abstract write(arg0: Internal.ByteBuffer_): number;
        abstract read(arg0: Internal.ByteBuffer_): number;
        abstract isOpen(): boolean;
        abstract position(): number;
        abstract truncate(arg0: number): this;
        abstract close(): void;
        abstract position(arg0: number): this;
        abstract size(): number;
        get open(): boolean
    }
    type SeekableByteChannel_ = SeekableByteChannel;
    interface ShortSpliterator extends Internal.Spliterator$OfPrimitive<number, Internal.ShortConsumer, Internal.ShortSpliterator> {
        forEachRemaining(arg0: Internal.ShortConsumer_): void;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        trySplit(): Internal.Spliterator$OfPrimitive<any, any, any>;
        getComparator(): Internal.Comparator<any>;
        getExactSizeIfKnown(): number;
        abstract tryAdvance(arg0: Internal.ShortConsumer_): boolean;
        hasCharacteristics(arg0: number): boolean;
        /**
         * @deprecated
        */
        tryAdvance(arg0: Internal.Consumer_<number>): boolean;
        skip(arg0: number): number;
        abstract characteristics(): number;
        abstract estimateSize(): number;
        get comparator(): Internal.Comparator<any>
        get exactSizeIfKnown(): number
    }
    type ShortSpliterator_ = ShortSpliterator;
    class AgeableSeveringRecipe$Serializer extends Internal.LoggingRecipeSerializer<Internal.AgeableSeveringRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.AgeableSeveringRecipe;
    }
    type AgeableSeveringRecipe$Serializer_ = AgeableSeveringRecipe$Serializer;
    interface IAEFacade {
        abstract getFacadeState(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Direction_): Internal.BlockState;
        (arg0: Internal.BlockGetter, arg1: BlockPos, arg2: Internal.Direction): Internal.BlockState_;
    }
    type IAEFacade_ = IAEFacade;
    class CountingMap {
        constructor()
        add(key: any, value: number): number;
        set(key: any, value: number): number;
        forEach(forEach: Internal.Consumer_<Internal.Object2LongEntry>): void;
        getValues(): Internal.Collection<number>;
        get(key: any): number;
        getSize(): number;
        clear(): void;
        getTotalCount(): number;
        getEntries(): Internal.List<Internal.Object2LongEntry>;
        getKeys(): Internal.Set<any>;
        get values(): Internal.Collection<number>
        get size(): number
        get totalCount(): number
        get entries(): Internal.List<Internal.Object2LongEntry>
        get keys(): Internal.Set<any>
    }
    type CountingMap_ = CountingMap;
    interface PlayerAttributesExtensions {
        canReach(entityHitVec: Vec3d_, padding: number): boolean;
        canReach(entity: Internal.Entity_, padding: number): boolean;
        isCloseEnough(entity: Internal.Entity_, dist: number): boolean;
        getEntityReach(): number;
        canReach(pos: BlockPos_, padding: number): boolean;
        getBlockReach(): number;
        get entityReach(): number
        get blockReach(): number
    }
    type PlayerAttributesExtensions_ = PlayerAttributesExtensions;
    interface IProtectAgainstDragonItem {
    }
    type IProtectAgainstDragonItem_ = IProtectAgainstDragonItem;
    class KeyDispatchDataCodec <A> extends Internal.Record {
        constructor($$0: Internal.Codec_<A>)
        codec(): Internal.Codec<A>;
        static of<A>($$0: Internal.MapCodec_<A>): Internal.KeyDispatchDataCodec<A>;
        static of<A>($$0: Internal.Codec_<A>): Internal.KeyDispatchDataCodec<A>;
    }
    type KeyDispatchDataCodec_<A> = KeyDispatchDataCodec<A>;
    class AEFluidKey extends Internal.AEKey {
        toVariant(): Internal.FluidVariant;
        static matches(what: Internal.AEKey_, fluid: Internal.FluidVariant_): boolean;
        copyTag(): Internal.CompoundTag;
        static of(fluid: Internal.Fluid_, tag: Internal.CompoundTag_): Internal.AEFluidKey;
        static is(stack: Internal.GenericStack_): boolean;
        static of(fluidVariant: Internal.FluidVariant_): Internal.AEFluidKey;
        matches(variant: Internal.FluidVariant_): boolean;
        static fromTag(tag: Internal.CompoundTag_): Internal.AEFluidKey;
        dropSecondary(): this;
        static filter(): Internal.AEKeyFilter;
        static fromPacket(data: Internal.FriendlyByteBuf_): Internal.AEFluidKey;
        hasTag(): boolean;
        getTag(): Internal.CompoundTag;
        getFluid(): Internal.Fluid;
        static of(fluid: Internal.Fluid_): Internal.AEFluidKey;
        static is(what: Internal.AEKey_): boolean;
        get tag(): Internal.CompoundTag
        get fluid(): Internal.Fluid
        static readonly AMOUNT_BLOCK: 81000;
        static readonly AMOUNT_BUCKET: 81000;
    }
    type AEFluidKey_ = AEFluidKey;
    class MoltenElectrumFluid extends Internal.MoltenMetalFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenElectrumFluid_ = MoltenElectrumFluid;
    class BookEntry extends Internal.AbstractReadStateHolder implements Internal.Comparable<Internal.BookEntry> {
        constructor(root: Internal.JsonObject_, id: ResourceLocation_, book: Internal.Book_, addedBy: string)
        getEntryColor(): number;
        isPriority(): boolean;
        isFoundByQuery(query: string): boolean;
        updateLockStatus(): void;
        addRelevantStack(builder: Internal.BookContentsBuilder_, stack: Internal.ItemStack_, page: number): void;
        shouldHide(): boolean;
        isSecret(): boolean;
        getBook(): Internal.Book;
        getPageFromAnchor(anchor: string): number;
        compareTo(arg0: any): number;
        getIcon(): Internal.BookIcon;
        getCategory(): Internal.BookCategory;
        compareTo(o: Internal.BookEntry_): number;
        isLocked(): boolean;
        canAdd(): boolean;
        getId(): ResourceLocation;
        getName(): Internal.MutableComponent;
        getPages(): Internal.List<Internal.BookPage>;
        initCategory(file: ResourceLocation_, categories: Internal.Function_<ResourceLocation, Internal.BookCategory>): void;
        build(level: Internal.Level_, builder: Internal.BookContentsBuilder_): void;
        getAddedBy(): string;
        get entryColor(): number
        get priority(): boolean
        get secret(): boolean
        get book(): Internal.Book
        get icon(): Internal.BookIcon
        get category(): Internal.BookCategory
        get locked(): boolean
        get id(): ResourceLocation
        get name(): Internal.MutableComponent
        get pages(): Internal.List<Internal.BookPage>
        get addedBy(): string
    }
    type BookEntry_ = BookEntry;
    class AnchorbladeItem extends Internal.PickaxeItem implements Internal.CustomHitParticleItem, Internal.CustomHitSoundItem, Internal.ArsenalWeaponItem {
        constructor(material: Internal.Tier_, attackDamage: number, attackSpeed: number, settings: Internal.Item$Properties_)
        playHitSound(player: Internal.Player_): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        spawnHitParticles(player: Internal.Player_): void;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type AnchorbladeItem_ = AnchorbladeItem;
    class Object2FloatOpenHashMap <K> extends Internal.AbstractObject2FloatMap<K> implements Internal.Cloneable, Internal.Hash, Internal.Serializable {
        constructor(arg0: Internal.Object2FloatMap_<K>)
        constructor(arg0: K[], arg1: number[], arg2: number)
        constructor()
        constructor(arg0: Internal.Map_<K, number>)
        constructor(arg0: K[], arg1: number[])
        constructor(arg0: Internal.Map_<K, number>, arg1: number)
        constructor(arg0: number)
        constructor(arg0: number, arg1: number)
        constructor(arg0: Internal.Object2FloatMap_<K>, arg1: number)
        andThenObject<T>(arg0: Internal.Float2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        andThenChar(arg0: Internal.Float2CharFunction_): Internal.Object2CharFunction<K>;
        /**
         * @deprecated
        */
        containsValue(arg0: any): boolean;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2FloatFunction;
        trim(arg0: number): boolean;
        mergeFloat(arg0: K, arg1: number, arg2: Internal.FloatBinaryOperator_): number;
        andThenReference<T>(arg0: Internal.Float2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        apply(arg0: K): number;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        mergeFloat(arg0: K, arg1: number, arg2: Internal.DoubleBinaryOperator_): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        /**
         * @deprecated
        */
        replace(arg0: any, arg1: any, arg2: any): boolean;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: K, arg1: number): number;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2FloatFunction;
        trim(): boolean;
        clone(): this;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2FloatFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2FloatFunction;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2FloatFunction;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        addTo(arg0: K, arg1: number): number;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        static identity<T>(): Internal.Function<T, T>;
        /**
         * @deprecated
        */
        merge(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: any, arg1: any): any;
        forEach(arg0: Internal.BiConsumer_<K, number>): void;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        static of<K, V>(): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        computeFloatIfAbsent(arg0: K, arg1: Internal.ToDoubleFunction_<K>): number;
        object2FloatEntrySet(): Internal.ObjectSet<any>;
        andThenShort(arg0: Internal.Float2ShortFunction_): Internal.Object2ShortFunction<K>;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        andThenByte(arg0: Internal.Float2ByteFunction_): Internal.Object2ByteFunction<K>;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2FloatFunction<T>;
        /**
         * @deprecated
        */
        entrySet(): Internal.ObjectSet<Internal.Map$Entry<K, number>>;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: number, arg2: number): boolean;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2FloatFunction;
        compute(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        /**
         * @deprecated
        */
        computeFloatIfAbsentPartial(arg0: K, arg1: Internal.Object2FloatFunction_<K>): number;
        applyAsDouble(arg0: K): number;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: number): number;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2FloatFunction;
        keySet(): Internal.ObjectSet<K>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        andThenDouble(arg0: Internal.Float2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        remove(arg0: any, arg1: any): boolean;
        /**
         * @deprecated
        */
        mergeFloat(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        replaceAll(arg0: Internal.BiFunction_<K, number, number>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2FloatFunction;
        andThenLong(arg0: Internal.Float2LongFunction_): Internal.Object2LongFunction<K>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        replace(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        merge(arg0: any, arg1: any, arg2: Internal.BiFunction_<any, any, any>): any;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        andThenInt(arg0: Internal.Float2IntFunction_): Internal.Object2IntFunction<K>;
        andThenFloat(arg0: Internal.Float2FloatFunction_): Internal.Object2FloatFunction<K>;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, number>): number;
    }
    type Object2FloatOpenHashMap_<K> = Object2FloatOpenHashMap<K>;
    interface K2 {
    }
    type K2_ = K2;
    abstract class BlockEntityMediafiedStorage$AnimationState {
        constructor(progress: number, $constructor_marker: any_)
        getProgress(): number;
        setProgress(<set-?>: number): void;
        get progress(): number
        set progress(<set-?>: number)
    }
    type BlockEntityMediafiedStorage$AnimationState_ = BlockEntityMediafiedStorage$AnimationState;
    interface K1 {
    }
    type K1_ = K1;
    class CarvedPumpkinBlock extends Internal.HorizontalDirectionalBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        static updatePatternBlocks($$0: Internal.Level_, $$1: Internal.BlockPattern$BlockPatternMatch_): void;
        canSpawnGolem($$0: Internal.LevelReader_, $$1: BlockPos_): boolean;
        static clearPatternBlocks($$0: Internal.Level_, $$1: Internal.BlockPattern$BlockPatternMatch_): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.DirectionProperty;
    }
    type CarvedPumpkinBlock_ = CarvedPumpkinBlock;
    class ShulkerBoxMenu extends Internal.AbstractContainerMenu {
        constructor($$0: number, $$1: Internal.Inventory_)
        constructor($$0: number, $$1: Internal.Inventory_, $$2: net.minecraft.world.Container_)
    }
    type ShulkerBoxMenu_ = ShulkerBoxMenu;
    class MobCategory extends Internal.Enum<Internal.MobCategory> implements Internal.StringRepresentable {
        getDespawnDistance(): number;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.MobCategory[];
        getSerializedName(): string;
        getName(): string;
        isFriendly(): boolean;
        isPersistent(): boolean;
        static valueOf($$0: string): Internal.MobCategory;
        getNoDespawnDistance(): number;
        getMaxInstancesPerChunk(): number;
        get despawnDistance(): number
        get serializedName(): string
        get name(): string
        get friendly(): boolean
        get persistent(): boolean
        get noDespawnDistance(): number
        get maxInstancesPerChunk(): number
        static readonly AMBIENT: Internal.MobCategory;
        static readonly CREATURE: Internal.MobCategory;
        static readonly MISC: Internal.MobCategory;
        static readonly MONSTER: Internal.MobCategory;
        static readonly WATER_AMBIENT: Internal.MobCategory;
        static readonly CODEC: Internal.Codec<Internal.MobCategory>;
        static readonly AXOLOTLS: Internal.MobCategory;
        static readonly WATER_CREATURE: Internal.MobCategory;
        static readonly UNDERGROUND_WATER_CREATURE: Internal.MobCategory;
    }
    type MobCategory_ = "monster" | "underground_water_creature" | "misc" | "creature" | string | "water_ambient" | "axolotls" | "ambient" | MobCategory | "water_creature";
    class DirectMethodHandleDesc$Kind extends Internal.Enum<Internal.DirectMethodHandleDesc$Kind> {
        static values(): Internal.DirectMethodHandleDesc$Kind[];
        static valueOf(arg0: string): Internal.DirectMethodHandleDesc$Kind;
        static valueOf(arg0: number, arg1: boolean): Internal.DirectMethodHandleDesc$Kind;
        static valueOf(arg0: number): Internal.DirectMethodHandleDesc$Kind;
        static readonly INTERFACE_SPECIAL: Internal.DirectMethodHandleDesc$Kind;
        readonly isInterface: boolean;
        static readonly STATIC_SETTER: Internal.DirectMethodHandleDesc$Kind;
        static readonly CONSTRUCTOR: Internal.DirectMethodHandleDesc$Kind;
        static readonly SPECIAL: Internal.DirectMethodHandleDesc$Kind;
        static readonly STATIC: Internal.DirectMethodHandleDesc$Kind;
        static readonly SETTER: Internal.DirectMethodHandleDesc$Kind;
        static readonly INTERFACE_VIRTUAL: Internal.DirectMethodHandleDesc$Kind;
        static readonly GETTER: Internal.DirectMethodHandleDesc$Kind;
        static readonly VIRTUAL: Internal.DirectMethodHandleDesc$Kind;
        readonly refKind: number;
        static readonly INTERFACE_STATIC: Internal.DirectMethodHandleDesc$Kind;
        static readonly STATIC_GETTER: Internal.DirectMethodHandleDesc$Kind;
    }
    type DirectMethodHandleDesc$Kind_ = "static" | "constructor" | "interface_special" | "static_getter" | "setter" | "virtual" | DirectMethodHandleDesc$Kind | "getter" | "interface_static" | "special" | "static_setter" | "interface_virtual";
    class FireGauntletItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type FireGauntletItem_ = FireGauntletItem;
    class SimpleFlowableFluid$Source extends com.tterrag.registrate.fabric.SimpleFlowableFluid {
        constructor(properties: Internal.SimpleFlowableFluid$Properties_)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type SimpleFlowableFluid$Source_ = SimpleFlowableFluid$Source;
    interface MouseUp {
        abstract onMouseUp(arg0: number, arg1: number, arg2: number): boolean;
        newStream(): Internal.EventStream<Internal.MouseUp>;
        (arg0: number, arg1: number, arg2: number): boolean;
    }
    type MouseUp_ = MouseUp;
    interface IAreaOfEffectIterator extends Internal.GenericLoaderRegistry$IHaveLoader<Internal.IAreaOfEffectIterator> {
        abstract getBlocks(arg0: Internal.IToolStackView_, arg1: Internal.ItemStack_, arg2: Internal.Player_, arg3: Internal.BlockState_, arg4: Internal.Level_, arg5: BlockPos_, arg6: Internal.Direction_, arg7: Internal.IAreaOfEffectIterator$AOEMatchType_): Internal.Iterable<BlockPos>;
        defaultBlockPredicate(tool: Internal.IToolStackView_, stack: Internal.ItemStack_, world: Internal.Level_, origin: BlockPos_, matchType: Internal.IAreaOfEffectIterator$AOEMatchType_): Internal.Predicate<BlockPos>;
        abstract getLoader(): Internal.GenericLoaderRegistry$IGenericLoader<Internal.IAreaOfEffectIterator>;
        get loader(): Internal.GenericLoaderRegistry$IGenericLoader<Internal.IAreaOfEffectIterator>
        readonly LOADER: Internal.GenericLoaderRegistry<Internal.IAreaOfEffectIterator>;
        readonly DEFAULT: Internal.IAreaOfEffectIterator;
    }
    type IAreaOfEffectIterator_ = IAreaOfEffectIterator;
    interface IBufferBuilder {
        abstract immediatelyFast$isReleased(): boolean;
        abstract immediatelyFast$release(): void;
    }
    type IBufferBuilder_ = IBufferBuilder;
    interface IRecipeContainer extends net.minecraft.world.Container {
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        abstract isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        /**
         * @deprecated
        */
        removeItem(index: number, count: number): Internal.ItemStack;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        abstract getContainerSize(): number;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        /**
         * @deprecated
        */
        setItem(index: number, stack: Internal.ItemStack_): void;
        getHeight(): number;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        removeItemNoUpdate(index: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        stillValid(player: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        abstract getItem(arg0: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        /**
         * @deprecated
        */
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get slots(): number
        get containerSize(): number
        get height(): number
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
    }
    type IRecipeContainer_ = IRecipeContainer;
    interface NodeList {
        abstract item(arg0: number): org.w3c.dom.Node;
        abstract getLength(): number;
        get length(): number
    }
    type NodeList_ = NodeList;
    class ModLabelItem extends Internal.LabelItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ModLabelItem_ = ModLabelItem;
    class TurtleCommandResult {
        isSuccess(): boolean;
        getErrorMessage(): string;
        static failure(): Internal.TurtleCommandResult;
        static success(): Internal.TurtleCommandResult;
        static failure(errorMessage: string): Internal.TurtleCommandResult;
        static success(results: any[]): Internal.TurtleCommandResult;
        getResults(): any[];
        get success(): boolean
        get errorMessage(): string
        get results(): any[]
    }
    type TurtleCommandResult_ = TurtleCommandResult;
    class ModuleDescriptor$Provides implements Internal.Comparable<Internal.ModuleDescriptor$Provides> {
        service(): string;
        compareTo(arg0: Internal.ModuleDescriptor$Provides_): number;
        providers(): Internal.List<string>;
        compareTo(arg0: any): number;
    }
    type ModuleDescriptor$Provides_ = ModuleDescriptor$Provides;
    interface Byte2ShortFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.IntUnaryOperator {
        andThenByte(arg0: Internal.Short2ByteFunction_): Internal.Byte2ByteFunction;
        composeDouble(arg0: Internal.Double2ByteFunction_): Internal.Double2ShortFunction;
        andThenLong(arg0: Internal.Short2LongFunction_): Internal.Byte2LongFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        andThenReference<T>(arg0: Internal.Short2ReferenceFunction_<T>): Internal.Byte2ReferenceFunction<T>;
        composeShort(arg0: Internal.Short2ByteFunction_): Internal.Short2ShortFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeByte(arg0: Internal.Byte2ByteFunction_): this;
        andThenShort(arg0: Internal.Short2ShortFunction_): this;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        defaultReturnValue(): number;
        put(arg0: number, arg1: number): number;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        andThenDouble(arg0: Internal.Short2DoubleFunction_): Internal.Byte2DoubleFunction;
        identity(): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        containsKey(arg0: number): boolean;
        composeReference<T>(arg0: Internal.Reference2ByteFunction_<T>): Internal.Reference2ShortFunction<T>;
        composeLong(arg0: Internal.Long2ByteFunction_): Internal.Long2ShortFunction;
        andThenFloat(arg0: Internal.Short2FloatFunction_): Internal.Byte2FloatFunction;
        getOrDefault(arg0: number, arg1: number): number;
        remove(arg0: number): number;
        composeFloat(arg0: Internal.Float2ByteFunction_): Internal.Float2ShortFunction;
        andThenInt(arg0: Internal.Short2IntFunction_): Internal.Byte2IntFunction;
        composeInt(arg0: Internal.Int2ByteFunction_): Internal.Int2ShortFunction;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        andThenChar(arg0: Internal.Short2CharFunction_): Internal.Byte2CharFunction;
        size(): number;
        abstract get(arg0: number): number;
        defaultReturnValue(arg0: number): void;
        apply(arg0: number): number;
        clear(): void;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenObject<T>(arg0: Internal.Short2ObjectFunction_<T>): Internal.Byte2ObjectFunction<T>;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        composeObject<T>(arg0: Internal.Object2ByteFunction_<T>): Internal.Object2ShortFunction<T>;
        composeChar(arg0: Internal.Char2ByteFunction_): Internal.Char2ShortFunction;
        (arg0: number): number;
    }
    type Byte2ShortFunction_ = Byte2ShortFunction;
    class BlockPredicateFilter extends Internal.PlacementFilter {
        static forPredicate($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): Internal.BlockPredicateFilter;
        static readonly CODEC: Internal.Codec<Internal.BlockPredicateFilter>;
    }
    type BlockPredicateFilter_ = BlockPredicateFilter;
    interface DynamicLightHandlerHolder <T> {
        abstract lambdynlights$getName(): net.minecraft.network.chat.Component;
        abstract lambdynlights$getId(): ResourceLocation;
        abstract lambdynlights$getSetting(): Internal.LightSourceSettingEntry;
        cast<T extends Internal.Entity>(entityType: Internal.EntityType_<T>): this;
    }
    type DynamicLightHandlerHolder_<T> = DynamicLightHandlerHolder<T>;
    class ClipboardBlock extends Internal.FaceAttachedHorizontalDirectionalBlock implements Internal.ProperWaterloggedBlock, Internal.IBE<Internal.ClipboardBlockEntity>, com.simibubi.create.content.equipment.wrench.IWrenchable {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ClipboardBlockEntity;
        setRequiresTool(v: boolean): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.ClipboardBlockEntity>;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ClipboardBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ClipboardBlockEntity>;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ClipboardBlockEntity>): void;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntityClass(): typeof Internal.ClipboardBlockEntity;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.ClipboardBlockEntity>
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.ClipboardBlockEntity
        static readonly WRITTEN: Internal.BooleanProperty;
    }
    type ClipboardBlock_ = ClipboardBlock;
    class BezierConnection$SegmentAngles {
        readonly length: number;
        readonly tieTransform: Internal.PoseStack$Pose[];
        readonly lightPosition: BlockPos[];
        readonly railTransforms: Internal.Couple<Internal.PoseStack$Pose>[];
    }
    type BezierConnection$SegmentAngles_ = BezierConnection$SegmentAngles;
    class ItemHippogryphSword extends Internal.SwordItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemHippogryphSword_ = ItemHippogryphSword;
    class BlockRedstoneImpetus extends Internal.BlockAbstractImpetus {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static sfx(pos: BlockPos_, bs: Internal.BlockState_, world: Internal.Level_, impetus: Internal.BlockEntityAbstractImpetus_, success: boolean): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        fakeThrowMishap(pos: BlockPos_, bs: Internal.BlockState_, image: Internal.CastingImage_, env: Internal.CircleCastEnv_, mishap: Internal.Mishap_): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        exitPositionFromDirection(pos: BlockPos_, dir: Internal.Direction_): com.mojang.datafixers.util.Pair<BlockPos, Internal.Direction>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly POWERED: Internal.BooleanProperty;
    }
    type BlockRedstoneImpetus_ = BlockRedstoneImpetus;
    interface SimpleRegistryAccessor <T> {
        abstract owo$getValueToEntry(): Internal.Map<T, Internal.Holder$Reference<T>>;
        abstract owo$getEntryToLifecycle(): Internal.Map<T, Internal.Lifecycle>;
    }
    type SimpleRegistryAccessor_<T> = SimpleRegistryAccessor<T>;
    interface INeighborChangeSensitive {
        abstract onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        (arg0: Internal.BlockState, arg1: Internal.LevelReader, arg2: BlockPos, arg3: BlockPos): void;
    }
    type INeighborChangeSensitive_ = INeighborChangeSensitive;
    interface DataSenderKJS {
        sendData(channel: string): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
    }
    type DataSenderKJS_ = DataSenderKJS;
    class ClientboundSetCarriedItemPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getSlot(): number;
        isSkippable(): boolean;
        get slot(): number
        get skippable(): boolean
    }
    type ClientboundSetCarriedItemPacket_ = ClientboundSetCarriedItemPacket;
    class EntityTickList {
        constructor()
        forEach($$0: Internal.Consumer_<Internal.Entity>): void;
        add($$0: Internal.Entity_): void;
        contains($$0: Internal.Entity_): boolean;
        remove($$0: Internal.Entity_): void;
    }
    type EntityTickList_ = EntityTickList;
    class CampfireBlockEntity extends Internal.BlockEntity implements Internal.SleepingBlockEntity, Internal.Clearable {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        placeFood($$0: Internal.Entity_, $$1: Internal.ItemStack_, $$2: number): boolean;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getItems(): Internal.NonNullList<Internal.ItemStack>;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        static cooldownTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.CampfireBlockEntity_): void;
        isSleeping(): boolean;
        getUpdatePacket(): Internal.Packet<any>;
        onLoad(): void;
        static cookTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.CampfireBlockEntity_): void;
        sleepOnlyCurrentTick(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        dowse(): void;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getSleepingTicker(): Internal.TickingBlockEntity;
        static particleTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.CampfireBlockEntity_): void;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        setTickWrapper(tickWrapper: Internal.WrappedBlockEntityTickInvokerAccessor_): void;
        getCookableRecipe($$0: Internal.ItemStack_): Internal.Optional<Internal.CampfireCookingRecipe>;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        startSleeping(): boolean;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        wakeUpNow(): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setTicker(delegate: Internal.TickingBlockEntity_): void;
        setSleepingTicker(sleepingTicker: Internal.TickingBlockEntity_): void;
        getTickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        clearContent(): void;
        get items(): Internal.NonNullList<Internal.ItemStack>
        get sleeping(): boolean
        get updatePacket(): Internal.Packet<any>
        get sleepingTicker(): Internal.TickingBlockEntity
        set tickWrapper(tickWrapper: Internal.WrappedBlockEntityTickInvokerAccessor_)
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        set ticker(delegate: Internal.TickingBlockEntity_)
        set sleepingTicker(sleepingTicker: Internal.TickingBlockEntity_)
        get tickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor
        readonly cookingProgress: number[];
        readonly cookingTime: number[];
    }
    type CampfireBlockEntity_ = CampfireBlockEntity;
    class OceanRuinStructure$Type extends Internal.Enum<Internal.OceanRuinStructure$Type> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.OceanRuinStructure$Type[];
        getSerializedName(): string;
        getName(): string;
        static valueOf($$0: string): Internal.OceanRuinStructure$Type;
        get serializedName(): string
        get name(): string
        static readonly COLD: Internal.OceanRuinStructure$Type;
        static readonly CODEC: Internal.Codec<Internal.OceanRuinStructure$Type>;
        static readonly WARM: Internal.OceanRuinStructure$Type;
    }
    type OceanRuinStructure$Type_ = "warm" | "cold" | OceanRuinStructure$Type;
    interface TagVisitor {
        abstract visitFloat(arg0: Internal.FloatTag_): void;
        abstract visitByte(arg0: Internal.ByteTag_): void;
        abstract visitLongArray(arg0: Internal.LongArrayTag_): void;
        abstract visitList(arg0: Internal.ListTag_): void;
        abstract visitShort(arg0: Internal.ShortTag_): void;
        abstract visitEnd(arg0: Internal.EndTag_): void;
        abstract visitIntArray(arg0: Internal.IntArrayTag_): void;
        abstract visitInt(arg0: Internal.IntTag_): void;
        abstract visitByteArray(arg0: Internal.ByteArrayTag_): void;
        abstract visitString(arg0: Internal.StringTag_): void;
        abstract visitCompound(arg0: Internal.CompoundTag_): void;
        abstract visitDouble(arg0: Internal.DoubleTag_): void;
        abstract visitLong(arg0: Internal.LongTag_): void;
    }
    type TagVisitor_ = TagVisitor;
    interface BiomeManagerAccessor {
        abstract port_lib$getBiomeZoomSeed(): number;
        (): number;
    }
    type BiomeManagerAccessor_ = BiomeManagerAccessor;
    interface DoublePredicate {
        abstract test(arg0: number): boolean;
        or(arg0: Internal.DoublePredicate_): this;
        and(arg0: Internal.DoublePredicate_): this;
        negate(): this;
        (arg0: number): boolean;
    }
    type DoublePredicate_ = DoublePredicate;
    class FactoryPanelConnection {
        constructor(from: Internal.FactoryPanelPosition_, amount: number)
        static read(nbt: Internal.CompoundTag_): Internal.FactoryPanelConnection;
        calculatePathDiff(state: Internal.BlockState_, to: Internal.FactoryPanelPosition_): Vec3d;
        write(): Internal.CompoundTag;
        getPath(level: Internal.Level_, state: Internal.BlockState_, to: Internal.FactoryPanelPosition_): Internal.List<Internal.Direction>;
        from: Internal.FactoryPanelPosition;
        arrowBendMode: number;
        amount: number;
        success: boolean;
        cachedSource: Internal.WeakReference<any>;
        path: Internal.List<Internal.Direction>;
    }
    type FactoryPanelConnection_ = FactoryPanelConnection;
    interface CommandBuildContext$Configurable extends Internal.CommandBuildContext {
        abstract holderLookup<T>(arg0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup<T>;
        simple($$0: Internal.HolderLookup$Provider_, $$1: Internal.FeatureFlagSet_): Internal.CommandBuildContext;
        configurable($$0: Internal.RegistryAccess_, $$1: Internal.FeatureFlagSet_): this;
        abstract missingTagAccessPolicy(arg0: Internal.CommandBuildContext$MissingTagAccessPolicy_): void;
    }
    type CommandBuildContext$Configurable_ = CommandBuildContext$Configurable;
    class ValueLayouts$OfLongImpl extends Internal.ValueLayouts$AbstractValueLayout<Internal.ValueLayouts$OfLongImpl> implements Internal.ValueLayout$OfLong {
        static sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        static sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        static of(arg0: Internal.ByteOrder_): Internal.ValueLayout$OfLong;
        withoutName(): Internal.ValueLayout$OfLong;
        withName(arg0: string): Internal.ValueLayout$OfLong;
        byteOffset(...arg0: any_[]): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        static structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        withOrder(arg0: Internal.ByteOrder_): Internal.ValueLayout$OfLong;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        static paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        static unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
    }
    type ValueLayouts$OfLongImpl_ = ValueLayouts$OfLongImpl;
    class TrackNodeLocation$DiscoveredLocation extends Internal.TrackNodeLocation {
        constructor(dimension: Internal.ResourceKey_<Internal.Level>, vec: Vec3d_)
        constructor(level: Internal.Level_, vec: Vec3d_)
        constructor(level: Internal.Level_, x: number, y: number, z: number)
        materials(materialA: Internal.TrackMaterial_, materialB: Internal.TrackMaterial_): this;
        notInLineWith(direction: Vec3d_): boolean;
        withNormal(normal: Vec3d_): this;
        forceNode(): this;
        viaTurn(turn: Internal.BezierConnection_): this;
        getTurn(): Internal.BezierConnection;
        connectedViaTurn(): boolean;
        materialA(material: Internal.TrackMaterial_): this;
        materialB(material: Internal.TrackMaterial_): this;
        withDirection(direction: Vec3d_): this;
        getDirection(): Vec3d;
        differentMaterials(): boolean;
        withYOffset(yOffsetPixels: number): this;
        shouldForceNode(): boolean;
        get turn(): Internal.BezierConnection
        get direction(): Vec3d
    }
    type TrackNodeLocation$DiscoveredLocation_ = TrackNodeLocation$DiscoveredLocation;
    class PhantomNodeBlock extends Internal.AEBaseEntityBlock<any> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type PhantomNodeBlock_ = PhantomNodeBlock;
    abstract class Rectangle2D extends Internal.RectangularShape {
        abstract outcode(arg0: number, arg1: number): number;
        static intersect(arg0: Internal.Rectangle2D_, arg1: Internal.Rectangle2D_, arg2: Internal.Rectangle2D_): void;
        add(arg0: Internal.Point2D_): void;
        abstract createUnion(arg0: Internal.Rectangle2D_): this;
        outcode(arg0: Internal.Point2D_): number;
        add(arg0: number, arg1: number): void;
        intersectsLine(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        abstract setRect(arg0: number, arg1: number, arg2: number, arg3: number): void;
        add(arg0: Internal.Rectangle2D_): void;
        intersectsLine(arg0: Internal.Line2D_): boolean;
        setRect(arg0: Internal.Rectangle2D_): void;
        static union(arg0: Internal.Rectangle2D_, arg1: Internal.Rectangle2D_, arg2: Internal.Rectangle2D_): void;
        abstract createIntersection(arg0: Internal.Rectangle2D_): this;
        set rect(arg0: Internal.Rectangle2D_)
        static readonly OUT_TOP: 2;
        static readonly OUT_LEFT: 1;
        static readonly OUT_RIGHT: 4;
        static readonly OUT_BOTTOM: 8;
    }
    type Rectangle2D_ = Rectangle2D;
    abstract class WidgetLayout$_Simple implements Internal.WidgetLayout {
        constructor(_pre: number, _spacing: number, _post: number, sizeGetter: Internal.Function_<dev.ftb.mods.ftblibrary.ui.Widget, number>, positionSetter: Internal.BiConsumer_<dev.ftb.mods.ftblibrary.ui.Widget, number>)
        getLayoutPadding(): Internal.WidgetLayout$Padding;
        align(panel: Internal.Panel_): number;
        get layoutPadding(): Internal.WidgetLayout$Padding
    }
    type WidgetLayout$_Simple_ = WidgetLayout$_Simple;
    interface IArmorTextureProvider {
        abstract getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): ResourceLocation;
        (arg0: Internal.ItemStack, arg1: Internal.Entity, arg2: Internal.EquipmentSlot, arg3: string): ResourceLocation_;
    }
    type IArmorTextureProvider_ = IArmorTextureProvider;
    class BloodFluid$Flowing extends Internal.BloodFluid {
        constructor()
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type BloodFluid$Flowing_ = BloodFluid$Flowing;
    class TrackCouplerBlockEntity$OperationInfo extends Internal.Record {
        constructor(mode: Internal.TrackCouplerBlockEntity$OperationMode_, frontCarriage: Internal.Carriage_, backCarriage: Internal.Carriage_)
        frontCarriage(): Internal.Carriage;
        mode(): Internal.TrackCouplerBlockEntity$OperationMode;
        backCarriage(): Internal.Carriage;
        static readonly NONE: Internal.TrackCouplerBlockEntity$OperationInfo;
    }
    type TrackCouplerBlockEntity$OperationInfo_ = TrackCouplerBlockEntity$OperationInfo;
    class MapBanner {
        constructor($$0: BlockPos_, $$1: Internal.DyeColor_, $$2: net.minecraft.network.chat.Component_)
        getPos(): BlockPos;
        save(): Internal.CompoundTag;
        getColor(): Internal.DyeColor;
        getName(): net.minecraft.network.chat.Component;
        static load($$0: Internal.CompoundTag_): Internal.MapBanner;
        static fromWorld($$0: Internal.BlockGetter_, $$1: BlockPos_): Internal.MapBanner;
        getId(): string;
        getDecoration(): Internal.MapDecoration$Type;
        get pos(): BlockPos
        get color(): Internal.DyeColor
        get name(): net.minecraft.network.chat.Component
        get id(): string
        get decoration(): Internal.MapDecoration$Type
    }
    type MapBanner_ = MapBanner;
    class ParticleTypes$2 extends Internal.ParticleType<Internal.LightningArcParticleData> {
        codec(): Internal.Codec<Internal.LightningArcParticleData>;
    }
    type ParticleTypes$2_ = ParticleTypes$2;
    interface ETFPlayerEntity extends Internal.ETFEntity {
        abstract etf$getCustomName(): net.minecraft.network.chat.Component;
        abstract etf$getWorld(): Internal.Level;
        abstract etf$distanceTo(arg0: Internal.Entity_): number;
        abstract etf$getType(): Internal.EntityType<any>;
        abstract etf$isBlockEntity(): boolean;
        abstract etf$getNbt(): Internal.CompoundTag;
        abstract etf$getBlockPos(): BlockPos;
        abstract etf$isTeammate(arg0: Internal.Player_): boolean;
        abstract etf$getName(): net.minecraft.network.chat.Component;
        abstract etf$getBlockY(): number;
        /**
         * @deprecated
        */
        abstract etf$isPartVisible(arg0: Internal.PlayerModelPart_): boolean;
        abstract etf$getHandItems(): Internal.Iterable<Internal.ItemStack>;
        abstract etf$getArmorItems(): Internal.Iterable<Internal.ItemStack>;
        abstract etf$canBeBright(): boolean;
        abstract etf$getUuid(): Internal.UUID;
        abstract etf$getItemsEquipped(): Internal.Iterable<Internal.ItemStack>;
        abstract etf$getEntity(): Internal.Entity;
        abstract etf$getEntityKey(): string;
        /**
         * @deprecated
        */
        abstract etf$getPose(): Internal.Pose;
        abstract etf$getScoreboardTeam(): Internal.Team;
        abstract etf$getUuidAsString(): string;
        abstract etf$hasCustomName(): boolean;
        abstract etf$getOptifineId(): number;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        abstract etf$getInventory(): Internal.Inventory;
        abstract etf$getVelocity(): Vec3d;
    }
    type ETFPlayerEntity_ = ETFPlayerEntity;
    class XpItem extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type XpItem_ = XpItem;
    class ServerAdvancementManager extends Internal.SimpleJsonResourceReloadListener implements Internal.IdentifiableResourceReloadListener {
        constructor($$0: Internal.LootDataManager_)
        getAllAdvancements(): Internal.Collection<Internal.Advancement>;
        getAdvancement($$0: ResourceLocation_): Internal.Advancement;
        getName(): string;
        getFabricDependencies(): Internal.Collection<any>;
        getFabricId(): ResourceLocation;
        get allAdvancements(): Internal.Collection<Internal.Advancement>
        get name(): string
        get fabricDependencies(): Internal.Collection<any>
        get fabricId(): ResourceLocation
    }
    type ServerAdvancementManager_ = ServerAdvancementManager;
    class WitherWallSkullBlock extends Internal.WallSkullBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type WitherWallSkullBlock_ = WitherWallSkullBlock;
    class HoverEvent$Action <T> {
        constructor($$0: string, $$1: boolean, $$2: Internal.Function_<Internal.JsonElement, T>, $$3: Internal.Function_<T, Internal.JsonElement>, $$4: Internal.Function_<net.minecraft.network.chat.Component, T>)
        static getByName($$0: string): Internal.HoverEvent$Action<any>;
        isAllowedFromServer(): boolean;
        deserializeFromLegacy($$0: net.minecraft.network.chat.Component_): Internal.HoverEvent;
        getName(): string;
        serializeArg($$0: any): Internal.JsonElement;
        deserialize($$0: Internal.JsonElement_): Internal.HoverEvent;
        get allowedFromServer(): boolean
        get name(): string
        static readonly SHOW_ENTITY: Internal.HoverEvent$Action<Internal.HoverEvent$EntityTooltipInfo>;
        static readonly SHOW_TEXT: Internal.HoverEvent$Action<net.minecraft.network.chat.Component>;
        static readonly SHOW_ITEM: Internal.HoverEvent$Action<Internal.HoverEvent$ItemStackInfo>;
    }
    type HoverEvent$Action_<T> = HoverEvent$Action<T>;
    class HangingSignItem extends Internal.SignItem {
        constructor($$0: Internal.Block_, $$1: Internal.Block_, $$2: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type HangingSignItem_ = HangingSignItem;
    class ChargedSnowballItem extends owmii.powah.lib.item.ItemBase {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        oneTimeInfo(player: Internal.Player_, stack: Internal.ItemStack_, component: net.minecraft.network.chat.Component_): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getItemModelType(): Internal.ItemModelType;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get itemModelType(): Internal.ItemModelType
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ChargedSnowballItem_ = ChargedSnowballItem;
    class CardboardBlock extends Internal.Block {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly HORIZONTAL_AXIS: Internal.Property<Internal.Direction$Axis>;
    }
    type CardboardBlock_ = CardboardBlock;
    interface ObjectBidirectionalIterable <K> extends Internal.ObjectIterable<K> {
        forEach(arg0: Internal.Consumer_<K>): void;
        spliterator(): Internal.ObjectSpliterator<K>;
        abstract iterator(): Internal.ObjectBidirectionalIterator<K>;
        (): Internal.ObjectBidirectionalIterator_<K>;
    }
    type ObjectBidirectionalIterable_<K> = ObjectBidirectionalIterable<K>;
    class FluidContainerList$Category {
        getFilledItems(): Internal.List<Internal.Item>;
        getFirstFilled(): Internal.Optional<Internal.Item>;
        getEmptyContainer(): Internal.Item;
        getCapacity(): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getAmount(): number;
        getFillSound(): Internal.SoundEvent;
        isEmpty(): boolean;
        getEmptySound(): Internal.SoundEvent;
        get filledItems(): Internal.List<Internal.Item>
        get firstFilled(): Internal.Optional<Internal.Item>
        get emptyContainer(): Internal.Item
        get capacity(): number
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        get amount(): number
        get fillSound(): Internal.SoundEvent
        get empty(): boolean
        get emptySound(): Internal.SoundEvent
        static readonly CODEC: Internal.Codec<Internal.FluidContainerList$Category>;
    }
    type FluidContainerList$Category_ = FluidContainerList$Category;
    class Modifier implements Internal.GenericLoaderRegistry$IHaveLoader<Internal.Modifier> {
        constructor()
        /**
         * @deprecated
        */
        onRemoved(tool: Internal.IToolStackView_): void;
        /**
         * @deprecated
        */
        addInformation(tool: Internal.IToolStackView_, level: number, player: Internal.Player_, tooltip: Internal.List_<net.minecraft.network.chat.Component>, tooltipKey: Internal.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): void;
        getTextColor(): Internal.TextColor;
        /**
         * @deprecated
        */
        onBreakSpeed(tool: Internal.IToolStackView_, level: number, event: Internal.PlayerEvents$BreakSpeed_, sideHit: Internal.Direction_, isEffective: boolean, miningSpeedModifier: number): void;
        /**
         * @deprecated
        */
        addVolatileData(context: Internal.ToolRebuildContext_, level: number, volatileData: Internal.ModDataNBT_): void;
        getColor(): number;
        /**
         * @deprecated
        */
        addToolStats(context: Internal.ToolRebuildContext_, level: number, builder: Internal.ModifierStatsBuilder_): void;
        /**
         * @deprecated
        */
        getModule<T>(type: T): T;
        getHooks(): Internal.ModifierHookMap;
        /**
         * @deprecated
        */
        getEntityDamage(tool: Internal.IToolStackView_, level: number, context: Internal.ToolAttackContext_, baseDamage: number, damage: number): number;
        getLoader(): Internal.GenericLoaderRegistry$IGenericLoader<Internal.Modifier>;
        /**
         * @deprecated
        */
        getProtectionModifier(tool: Internal.IToolStackView_, level: number, context: Internal.EquipmentContext_, slotType: Internal.EquipmentSlot_, source: DamageSource_, modifierValue: number): number;
        getEffectiveLevel(tool: Internal.IToolContext_, level: number): number;
        /**
         * @deprecated
        */
        canPerformAction(tool: Internal.IToolStackView_, level: number, toolAction: Internal.ToolAction_): boolean;
        getDescription(tool: Internal.IToolStackView_, level: number): net.minecraft.network.chat.Component;
        processLoot(tool: Internal.IToolStackView_, level: number, generatedLoot: Internal.ObjectArrayList_<Internal.ItemStack>, context: Internal.LootContext_): Internal.ObjectArrayList<Internal.ItemStack>;
        /**
         * @deprecated
        */
        onEquipmentChange(tool: Internal.IToolStackView_, level: number, context: Internal.EquipmentChangeContext_, slotType: Internal.EquipmentSlot_): void;
        getPriority(): number;
        /**
         * @deprecated
        */
        finishBreakingBlocks(tool: Internal.IToolStackView_, level: number, context: Internal.ToolHarvestContext_): void;
        getDescriptionList(): Internal.List<net.minecraft.network.chat.Component>;
        /**
         * @deprecated
        */
        addRawData(tool: Internal.IToolStackView_, level: number, tag: Internal.RestrictedCompoundTag_): void;
        /**
         * @deprecated
        */
        removeBlock(tool: Internal.IToolStackView_, level: number, context: Internal.ToolHarvestContext_): boolean;
        static getMiningModifier(entity: Internal.LivingEntity_): number;
        /**
         * @deprecated
        */
        getUseDuration(tool: Internal.IToolStackView_, level: number): number;
        clearCache(packType: Internal.PackType_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        applyHarvestEnchantments(tool: Internal.IToolStackView_, level: number, context: Internal.ToolHarvestContext_, consumer: Internal.BiConsumer_<Internal.Enchantment, number>): void;
        getDurabilityRGB(tool: Internal.IToolStackView_, level: number): number;
        /**
         * @deprecated
        */
        getRepairFactor(toolStack: Internal.IToolStackView_, level: number, factor: number): number;
        getDisplayName(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getLootingValue(tool: Internal.IToolStackView_, level: number, holder: Internal.LivingEntity_, target: Internal.Entity_, damageSource: DamageSource_, looting: number): number;
        getDescriptionList(tool: Internal.IToolStackView_, level: number): Internal.List<net.minecraft.network.chat.Component>;
        onInventoryTick(tool: Internal.IToolStackView_, level: number, world: Internal.Level_, holder: Internal.LivingEntity_, itemSlot: number, isSelected: boolean, isCorrectSlot: boolean, stack: Internal.ItemStack_): void;
        static getHeldTool(living: Internal.LivingEntity_, slot: Internal.EquipmentSlot_): Internal.ToolStack;
        /**
         * @deprecated
        */
        failedEntityHit(tool: Internal.IToolStackView_, level: number, context: Internal.ToolAttackContext_): void;
        /**
         * @deprecated
        */
        afterEntityUse(tool: Internal.IToolStackView_, level: number, player: Internal.Player_, target: Internal.LivingEntity_, hand: Internal.InteractionHand_, slot: Internal.EquipmentSlot_): Internal.InteractionResult;
        /**
         * @deprecated
        */
        validate(tool: Internal.IToolStackView_, level: number): Internal.ValidatedResult;
        getId(): Internal.ModifierId;
        getHook<T>(hook: Internal.ModifierHook_<T>): T;
        /**
         * @deprecated
        */
        onUnequip(tool: Internal.IToolStackView_, level: number, context: Internal.EquipmentChangeContext_): void;
        showDurabilityBar(tool: Internal.IToolStackView_, level: number): boolean;
        /**
         * @deprecated
        */
        isSourceBlocked(tool: Internal.IToolStackView_, level: number, context: Internal.EquipmentContext_, slotType: Internal.EquipmentSlot_, source: DamageSource_, amount: number): boolean;
        onDamageTool(tool: Internal.IToolStackView_, level: number, amount: number, holder: Internal.LivingEntity_): number;
        /**
         * @deprecated
        */
        onAttacked(tool: Internal.IToolStackView_, level: number, context: Internal.EquipmentContext_, slotType: Internal.EquipmentSlot_, source: DamageSource_, amount: number, isDirectDamage: boolean): void;
        /**
         * @deprecated
        */
        onEquip(tool: Internal.IToolStackView_, level: number, context: Internal.EquipmentChangeContext_): void;
        applyStyle(component: Internal.MutableComponent_): Internal.MutableComponent;
        getDisplayName(level: number): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        onToolUse(tool: Internal.IToolStackView_, level: number, world: Internal.Level_, player: Internal.Player_, hand: Internal.InteractionHand_, slot: Internal.EquipmentSlot_): Internal.InteractionResult;
        /**
         * @deprecated
        */
        onFinishUsing(tool: Internal.IToolStackView_, level: number, world: Internal.Level_, entity: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        addAttributes(tool: Internal.IToolStackView_, level: number, slot: Internal.EquipmentSlot_, consumer: Internal.BiConsumer_<Internal.Attribute, Internal.AttributeModifier>): void;
        getDescription(level: number): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        beforeEntityUse(tool: Internal.IToolStackView_, level: number, player: Internal.Player_, target: Internal.Entity_, hand: Internal.InteractionHand_, slot: Internal.EquipmentSlot_): Internal.InteractionResult;
        /**
         * @deprecated
        */
        beforeBlockUse(tool: Internal.IToolStackView_, level: number, context: Internal.UseOnContext_, slot: Internal.EquipmentSlot_): Internal.InteractionResult;
        getTranslationKey(): string;
        shouldDisplay(advanced: boolean): boolean;
        getDisplayName(tool: Internal.IToolStackView_, level: number): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        attackWithArmor(tool: Internal.IToolStackView_, level: number, context: Internal.EquipmentContext_, slotType: Internal.EquipmentSlot_, target: Internal.LivingEntity_, source: DamageSource_, amount: number, isDirectDamage: boolean): void;
        /**
         * @deprecated
        */
        onStoppedUsing(tool: Internal.IToolStackView_, level: number, world: Internal.Level_, entity: Internal.LivingEntity_, timeLeft: number): boolean;
        /**
         * @deprecated
        */
        afterBlockBreak(tool: Internal.IToolStackView_, level: number, context: Internal.ToolHarvestContext_): void;
        /**
         * @deprecated
        */
        getUseAction(tool: Internal.IToolStackView_, level: number): Internal.UseAnim;
        /**
         * @deprecated
        */
        afterEntityHit(tool: Internal.IToolStackView_, level: number, context: Internal.ToolAttackContext_, damageDealt: number): number;
        /**
         * @deprecated
        */
        afterBlockUse(tool: Internal.IToolStackView_, level: number, context: Internal.UseOnContext_, slot: Internal.EquipmentSlot_): Internal.InteractionResult;
        /**
         * @deprecated
        */
        beforeEntityHit(tool: Internal.IToolStackView_, level: number, context: Internal.ToolAttackContext_, damage: number, baseKnockback: number, knockback: number): number;
        is(tag: Internal.TagKey_<Internal.Modifier>): boolean;
        /**
         * @deprecated
        */
        beforeRemoved(tool: Internal.IToolStackView_, tag: Internal.RestrictedCompoundTag_): void;
        static getHeldTool(living: Internal.LivingEntity_, hand: Internal.InteractionHand_): Internal.ToolStack;
        /**
         * @deprecated
        */
        addInformation(tool: Internal.IToolStackView_, level: number, player: Internal.Player_, tooltip: Internal.List_<net.minecraft.network.chat.Component>, tooltipKey: slimeknights.tconstruct.library.utils.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): void;
        getDamagePercentage(tool: Internal.IToolStackView_, level: number): number;
        getDescriptionList(level: number): Internal.List<net.minecraft.network.chat.Component>;
        get textColor(): Internal.TextColor
        get color(): number
        get hooks(): Internal.ModifierHookMap
        get loader(): Internal.GenericLoaderRegistry$IGenericLoader<Internal.Modifier>
        get priority(): number
        get descriptionList(): Internal.List<net.minecraft.network.chat.Component>
        get description(): net.minecraft.network.chat.Component
        get displayName(): net.minecraft.network.chat.Component
        get id(): Internal.ModifierId
        get translationKey(): string
        static readonly DEFAULT_PRIORITY: 100;
        static readonly DEFAULT_LOADER: Internal.GenericLoaderRegistry$IGenericLoader<Internal.Modifier>;
    }
    type Modifier_ = Modifier;
}
declare namespace net.blay09.mods.kuma.mixin {
    interface KeyMappingAccessor {
        abstract getKey(): Internal.InputConstants$Key;
        get key(): Internal.InputConstants$Key
        (): Internal.InputConstants$Key_;
    }
    type KeyMappingAccessor_ = KeyMappingAccessor;
}
declare namespace appeng.client.render.effects {
    class ParticleTypes$1 extends Internal.ParticleType<Internal.EnergyParticleData> {
        codec(): Internal.Codec<Internal.EnergyParticleData>;
    }
    type ParticleTypes$1_ = ParticleTypes$1;
}
declare namespace io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor {
    interface MobAccessor {
        abstract port_lib$maybeDisableShield(arg0: Internal.Player_, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_): void;
        (arg0: Internal.Player, arg1: Internal.ItemStack, arg2: Internal.ItemStack): void;
    }
    type MobAccessor_ = MobAccessor;
}
declare namespace artifacts.mixin.accessors {
    interface LivingEntityAccessor {
        abstract getLastHurtByPlayerTime(): number;
        abstract getLastHurtByPlayer(): Internal.Player;
        get lastHurtByPlayerTime(): number
        get lastHurtByPlayer(): Internal.Player
    }
    type LivingEntityAccessor_ = LivingEntityAccessor;
}
